﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures.Core;
using System.Diagnostics;
using LayoutEditor.Forms.ToolWindows;

namespace LayoutEditor.src.Controls
{
    public partial class AnimationMarkNumericUpDown : UserControl
        , IAnimationMarkUsable
    {
        #region イベント

        public event EventHandler ValueChanged
        {
            add { _nudNumericUpDown.ValueChanged += value; }
            remove { _nudNumericUpDown.ValueChanged -= value; }
        }

        #endregion

        #region フィールド

        private bool _useAnimationMark = false;

        private LayoutEditor.Controls.UINumericUpDown _nudNumericUpDown;
        private AnimationMark _pnlMark;

        /// <summary>
        /// 必要なデザイナー変数です。
        /// </summary>
        private System.ComponentModel.IContainer components = null;

        #endregion

        #region プロパティ

        public int DecimalPlace
        {
            get { return _nudNumericUpDown.DecimalPlaces; }
            set { _nudNumericUpDown.DecimalPlaces = value; }
        }

        public decimal Increment
        {
            get { return _nudNumericUpDown.Increment; }
            set { _nudNumericUpDown.Increment = value; }
        }

        public decimal Maximum
        {
            get { return _nudNumericUpDown.Maximum; }
            set { _nudNumericUpDown.Maximum = value; }
        }

        public decimal Minimum
        {
            get { return _nudNumericUpDown.Minimum; }
            set { _nudNumericUpDown.Minimum = value; }
        }

        public Size NumericUpDownSize
        {
            get { return _nudNumericUpDown.Size; }
            set { _nudNumericUpDown.Size = value; }
        }

        public HorizontalAlignment TextAlign
        {
            get { return _nudNumericUpDown.TextAlign; }
            set { _nudNumericUpDown.TextAlign = value; }
        }

        public decimal Value
        {
            get { return _nudNumericUpDown.Value; }
            set { _nudNumericUpDown.Value = value; }
        }

        public Color NumericUpDownBackColor
        {
            get { return _nudNumericUpDown.BackColor; }
            set { _nudNumericUpDown.BackColor = value; }
        }

        public AnimationMark AnimationMarkInst
        {
            get { return _pnlMark; }
        }

        #endregion

        public AnimationMarkNumericUpDown()
        {
            InitializeComponent();
        }

        public void SetValue(decimal newValue)
        {
            _nudNumericUpDown.SetValue(newValue);
        }

        /// <summary>
        /// ViewManagerへのメッセージハンドラを設定します。
        /// </summary>
        public void SetViewManagerMessageHandler(Action<ViewManagerMessage> handler)
        {
            _pnlMark.SendMessageToViewManager = handler;
        }

        /// <summary>
        /// コンテキストメニューを追加します。
        /// </summary>
        public void RegistContextMenu(string name, Image image, EventHandler handler)
        {
            _pnlMark.RegistContextMenu(name, image, handler);
        }

        /// <summary>
        /// 操作対象のアトリビュートを設定します
        /// </summary>
        public void SetTargetAttribute(IAnmAttribute attr)
        {
            Debug.Assert(attr.NumSubAttribute == 0);

            _pnlMark.SetTargetAttribute(attr);
        }
        public void SetTargetAttribute(IAnmAttribute[] attrs)
        {
            _pnlMark.ClearTargetAttribute();

            foreach (IAnmAttribute attr in attrs)
            {
                Debug.Assert(attr.NumSubAttribute == 0);

                _pnlMark.AddTargetAttribute(attr);
            }
        }

        /// <summary>
        /// アニメーションマークの色を更新します
        /// </summary>
        public void UpdateMarkColor()
        {
            _pnlMark.UpdateMarkColor();
        }

        /// <summary>
        /// コンテキストメニューを更新します
        /// </summary>
        public void UpdateContextMenu()
        {
            _pnlMark.UpdateContextMenu();
        }

        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースを破棄する場合は true を指定し、その他の場合は false を指定します。</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        #region IAnimationMarkUsableメンバ

        /// <summary>
        /// アニメーションマークを利用するか
        /// </summary>
        public bool UseAnimationMark
        {
            get { return _useAnimationMark; }
            set
            {
                _useAnimationMark = value;
                _pnlMark.Visible = value;
            }
        }

        /// <summary>
        /// アニメーションマークを更新します
        /// </summary>
        public void UpdateAnimationMark()
        {
            UpdateMarkColor();
            UpdateContextMenu();
        }

        #endregion

        #region コンポーネント デザイナーで生成されたコード

        /// <summary>
        /// デザイナー サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディターで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this._nudNumericUpDown = new LayoutEditor.Controls.UINumericUpDown();
            this._pnlMark = new LayoutEditor.src.Controls.AnimationMark();
            ((System.ComponentModel.ISupportInitialize)(this._nudNumericUpDown)).BeginInit();
            this.SuspendLayout();
            //
            // _nudNumericUpDown
            //
            this._nudNumericUpDown.Location = new System.Drawing.Point(7, 0);
            this._nudNumericUpDown.Name = "_nudNumericUpDown";
            this._nudNumericUpDown.Size = new System.Drawing.Size(120, 19);
            this._nudNumericUpDown.TabIndex = 0;
            this._nudNumericUpDown.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            //
            // _pnlMark
            //
            this._pnlMark.Location = new System.Drawing.Point(0, 0);
            this._pnlMark.Name = "_pnlMark";
            this._pnlMark.Size = new System.Drawing.Size(5, 19);
            this._pnlMark.TabIndex = 0;
            this._pnlMark.Visible = false;
            //
            // MarkNumericUpDown
            //
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 12F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.Controls.Add(this._pnlMark);
            this.Controls.Add(this._nudNumericUpDown);
            this.Name = "MarkNumericUpDown";
            this.Size = new System.Drawing.Size(127, 19);
            ((System.ComponentModel.ISupportInitialize)(this._nudNumericUpDown)).EndInit();
            this.ResumeLayout(false);

        }

        #endregion
    }
}
