﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace LayoutEditor
{
    /// <summary>
    /// アプリケーションイベント種類
    /// </summary>
    public enum AppEventKind
    {
        None,
        AppSettingChanged,
        RedrawAllLayout
    }

    /// <summary>
    /// アプリケーションイベント引数
    /// </summary>
    public class AppEventArgs : EventArgs
    {
        readonly AppEventKind _kind = AppEventKind.None;

        /// <summary>
        /// イベント種類
        /// </summary>
        public AppEventKind Kind {get { return _kind; }}

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AppEventArgs( AppEventKind kind )
        {
            _kind = kind;
        }
    }

    /// <summary>
    /// アプリケーションイベントリスナ
    /// アプリケーションイベントとはアプリケーションレイヤのイベント
    /// 通知を行う際に使用されるイベントです。
    /// </summary>
    public interface IAppEventListener
    {
        /// <summary>
        /// アプリケーションイベントハンドラ
        /// </summary>
        void OnAppEvent( object sender, AppEventArgs args );
    }
}
