﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace LECore.Structures
{
    #region ParamaterKind

    /// <summary>
    /// パラメータの種類
    /// </summary>
    [Flags]
    public enum ParamaterKind : ulong
    {
        // 基本
        None = 0x0,

        Position = 1ul << 0,
        Size = 1ul << 1,
        Scale = 1ul << 2,
        Rotate = 1ul << 3,
        UserComment = 1ul << 4,
        UserData = 1ul << 5,
        UserDataEx = 1ul << 6,
        Hierarchy = 1ul << 7,
        Group = 1ul << 8,
        Transparency = 1ul << 9,
        PaneBasicFlags = 1ul << 10,
        SRTAll =
            Position |
            Scale |
            Rotate,
        UserDataAll =
            UserData |
            UserComment |
            UserDataEx,
        // Picture
        VtxColors = 1ul << 11,
        TexCoords = 1ul << 12,
        PictureEtc = 1ul << 13,

        PictureAll =
            VtxColors |
            TexCoords |
            PictureEtc |
            PictureShapeType |
            ProceduralShapeAll,

        // TextBox
        FontFileName = 1ul << 14,
        ContentsText = 1ul << 15,
        FontSize = 1ul << 16,
        FontBlank = 1ul << 17,
        TextBasePosition = 1ul << 18,
        FontColors = 1ul << 19,
        TextShadow = 1ul << 20,
        PerCharTransformParam = 1ul << 21,
        PerCharTransformCurve = 1ul << 22,
        PerCharTransform = PerCharTransformParam | PerCharTransformCurve,
        TextExtra = 1ul << 23,

        TextBoxAll =
            FontFileName |
            ContentsText |
            FontSize |
            FontBlank |
            TextBasePosition |
            FontColors |
            TextShadow |
            PerCharTransform |
            TextExtra,

        // Window
        WindowFrame = 1ul << 24,
        WindowContentsParamaters = 1ul << 25,

        WindowAll =
            WindowFrame |
            WindowContentsParamaters,

        // Parts
        PartsAll = 1ul << 26,

        // Alignment
        AlignmentAll = 1ul << 27,

        // Scissor
        ScissorAll = 1ul << 28,

        // Material
        Material_Textures = 1ul << 29,
        Material_ColorBlend = 1ul << 30,
        Material_Details = 1ul << 31,

        MaterialAll =
            Material_Textures |
            Material_ColorBlend,

        MaterialDetailsAll =
            MaterialAll |
            Material_Details,

        // Animation(ParamaterKindHelperへの追加も行うこと)　
        Animation_PaneSRT = 1ul << 32,
        Animation_MaterialColors = 1ul << 33,
        Animation_VertexColors = 1ul << 34,
        Animation_TextureSRT = 1ul << 35,
        Animation_IndirectTextureSRT = 1ul << 36,
        Animation_TexturePattern = 1ul << 37,
        Animation_Visivility = 1ul << 38,
        Animation_AlphaTest = 1ul << 39,
        Animation_FontShadowColor = 1ul << 40,
        Animation_PerCharacterTransform = 1ul << 41,
        Animation_PerCharacterTransformCurve = 1ul << 42,
        Animation_Window = 1ul << 43,
        Animation_ExtUserData = 1ul << 44,
        Animation_MaskTextureSRT = 1ul << 45,
        Animation_DropShadow = 1ul << 46,
        Animation_ProceduralShape = 1ul << 47,
        Animation_Pane = Animation_PaneSRT |
                                      Animation_VertexColors |
                                      Animation_Visivility |
                                      Animation_PerCharacterTransform |
                                      Animation_PerCharacterTransformCurve |
                                      Animation_Window,

        Animation_Material = Animation_MaterialColors |
                                      Animation_TextureSRT |
                                      Animation_IndirectTextureSRT |
                                      Animation_TexturePattern |
                                      Animation_AlphaTest |
                                      Animation_FontShadowColor,

        Animation_All = Animation_Pane |
                          Animation_Material|
                          Animation_MaskTextureSRT |
                          Animation_DropShadow |
                          Animation_ProceduralShape |
                          Animation_ExtUserData,

        // 全種類の頂点カラー
        AllVtxColor = 1ul << 48,
        // ピクチャペインの形状設定
        PictureShapeType = 1ul << 49,
        // マスク機能
        MaskAll = 1ul << 50,
        // ドロップシャドウ効果
        DropShadowAll = 1ul << 51,
        // 角丸
        ProceduralShapeAll = 1ul << 52,

        // すべて
        All = 0xFFFFFFFFFFFFFFFF
    }

    /// <summary>
    /// パラメータ種類関連、ヘルパクラス
    /// </summary>
    public class ParamaterKindHelper
    {
        /// <summary>
        /// アニメーションの種類です。
        /// </summary>
        static readonly public ParamaterKind[] AnimationKindSet =
        {
            ParamaterKind.Animation_PaneSRT,
            ParamaterKind.Animation_MaterialColors,
            ParamaterKind.Animation_VertexColors,
            ParamaterKind.Animation_TextureSRT,
            ParamaterKind.Animation_TexturePattern,
            ParamaterKind.Animation_Visivility,
            ParamaterKind.Animation_IndirectTextureSRT,
            ParamaterKind.Animation_AlphaTest,
            ParamaterKind.Animation_FontShadowColor,
            ParamaterKind.Animation_PerCharacterTransform,
            ParamaterKind.Animation_PerCharacterTransformCurve,
            ParamaterKind.Animation_Window,
            ParamaterKind.Animation_ExtUserData,
            ParamaterKind.Animation_MaskTextureSRT,
            ParamaterKind.Animation_DropShadow,
            ParamaterKind.Animation_ProceduralShape,
        };

        /// <summary>
        /// マテリアルに関係するアニメーションの種類です。
        /// </summary>
        static readonly public ParamaterKind[][] MaterialAnimationKindSet =
        {
            new ParamaterKind[] {
                ParamaterKind.Animation_MaterialColors,
                ParamaterKind.Animation_TextureSRT,
                ParamaterKind.Animation_TexturePattern,
            },
            new ParamaterKind[] {
                ParamaterKind.Animation_MaterialColors,
                ParamaterKind.Animation_IndirectTextureSRT,
                ParamaterKind.Animation_AlphaTest,
            }
        };

        /// <summary>
        /// ハード固有のアニメーションの種類です。
        /// </summary>
        static readonly public ParamaterKind[] RevHwAnimationKindSet =
        {
            ParamaterKind.Animation_MaterialColors,
        };
    }

    [Flags]
    public enum VectorElement
    {
        X = 0x00000001,
        Y = 0x00000002,
        Z = 0x00000004,
        XYZ_All = X | Y | Z,

        R = 0x00000010,
        G = 0x00000020,
        B = 0x00000040,
        A = 0x00000080,
        RGBA_All = R | G | B | A,
        All = XYZ_All | RGBA_All,
    }

    #endregion ParamaterKind

    #region ParamaterSubKind

    [Flags]
    public enum ParamaterSubKind : ulong
    {
        None = 0x0,

        BaseValue = 1ul << 0,
        CopyTargetTag = 1ul << 1,

        // すべて
        All = 0xFFFFFFFFFFFFFFFF
    }

    #endregion
}
