﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections;


namespace LECore.Structures.Nsrif.Attributes
{
    #region AttrScalingRule
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrScalingRule
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>standard</summary>
        Standard,
        /// <summary>softimage</summary>
        Softimage,
        /// <summary>maya</summary>
        Maya
    }
    #endregion

    #region AttrTexMatrixMode
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexMatrixMode
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>maya</summary>
        Maya,
        //		/// <summary>si3d</summary>
        //		Si3d,
        /// <summary>xsi</summary>
        Xsi,
        /// <summary>3dsmax</summary>
        Max
    }
    #endregion

    #region AttrCoordQuantize
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrCoordQuantize
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>float</summary>
        Float,
        /// <summary>fixed</summary>
        Fixed,
        /// <summary>auto</summary>
        Auto
    }
    #endregion

    #region AttrNormalQuantize
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrNormalQuantize
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>float</summary>
        Float,
        /// <summary>fixed6</summary>
        Fixed6,
        /// <summary>fixed14</summary>
        Fixed14
    }
    #endregion

    #region AttrColorType
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrColorType
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>rgb565</summary>
        Rgb565,
        /// <summary>rgb8</summary>
        Rgb8,
        /// <summary>rgbx8</summary>
        Rgbx8,
        /// <summary>rgba4</summary>
        Rgba4,
        /// <summary>rgba6</summary>
        Rgba6,
        /// <summary>rgba8</summary>
        Rgba8
    }
    #endregion

    #region AttrTransparencyMode
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTransparencyMode
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>opa</summary>
        Opa,
        /// <summary>xlu</summary>
        Xlu
    }
    #endregion

    #region AttrColorAssignName
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrColorAssignName
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>diffuse</summary>
        Diffuse,
        /// <summary>ambient</summary>
        Ambient,
        /// <summary>specular</summary>
        Specular,
        /// <summary>alpha</summary>
        Alpha
    }
    #endregion

    #region AttrColorAssignTarget
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrColorAssignTarget
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>mat_color0_rgb</summary>
        MatColor0Rgb,
        /// <summary>mat_color0_a</summary>
        MatColor0A,
        /// <summary>mat_color1_rgb</summary>
        MatColor1Rgb,
        /// <summary>mat_color1_a</summary>
        MatColor1A,
        /// <summary>amb_color0_rgb</summary>
        AmbColor0Rgb,
        /// <summary>amb_color0_a</summary>
        AmbColor0A,
        /// <summary>amb_color1_rgb</summary>
        AmbColor1Rgb,
        /// <summary>amb_color1_a</summary>
        AmbColor1A,
        /// <summary>tev_color0_rgb</summary>
        TevColor0Rgb,
        /// <summary>tev_color0_a</summary>
        TevColor0A,
        /// <summary>tev_color1_rgb</summary>
        TevColor1Rgb,
        /// <summary>tev_color1_a</summary>
        TevColor1A,
        /// <summary>tev_color2_rgb</summary>
        TevColor2Rgb,
        /// <summary>tev_color2_a</summary>
        TevColor2A,
        /// <summary>tev_constant0_rgb</summary>
        TevConstant0Rgb,
        /// <summary>tev_constant0_a</summary>
        TevConstant0A,
        /// <summary>tev_constant1_rgb</summary>
        TevConstant1Rgb,
        /// <summary>tev_constant1_a</summary>
        TevConstant1A,
        /// <summary>tev_constant2_rgb</summary>
        TevConstant2Rgb,
        /// <summary>tev_constant2_a</summary>
        TevConstant2A,
        /// <summary>tev_constant3_rgb</summary>
        TevConstant3Rgb,
        /// <summary>tev_constant3_a</summary>
        TevConstant3A
    }
    #endregion

    #region AttrChannel
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrChannel
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>color0</summary>
        Color0,
        /// <summary>alpha0</summary>
        Alpha0,
        /// <summary>color1</summary>
        Color1,
        /// <summary>alpha1</summary>
        Alpha1
    }
    #endregion

    #region AttrColorSource
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrColorSource
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>reg</summary>
        Reg,
        /// <summary>vtx</summary>
        Vtx
    }
    #endregion

    #region AttrDiffuseFunc
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrDiffuseFunc
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>none</summary>
        None,
        /// <summary>clamp</summary>
        Clamp,
        /// <summary>sign</summary>
        Sign
    }
    #endregion

    #region AttrAttnFunc
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrAttnFunc
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>none</summary>
        None,
        /// <summary>spot</summary>
        Spot,
        /// <summary>spec</summary>
        Spec
    }
    #endregion

    #region AttrTexWrap
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexWrap
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>clamp</summary>
        Clamp,
        /// <summary>repeat</summary>
        Repeat,
        /// <summary>mirror</summary>
        Mirror
    }
    #endregion

    #region AttrTexFilterMin
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexFilterMin
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>near</summary>
        Near,
        /// <summary>linear</summary>
        Linear,
        /// <summary>near_mip_near</summary>
        NearMipNear,
        /// <summary>near_mip_linear</summary>
        NearMipLinear,
        /// <summary>linear_mip_near</summary>
        LinearMipNear,
        /// <summary>linear_mip_linear</summary>
        LinearMipLinear
    }
    #endregion

    #region AttrTexFilterMag
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexFilterMag
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>near</summary>
        Near,
        /// <summary>linear</summary>
        Linear
    }
    #endregion

    #region AttrMaxAniso
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrMaxAniso
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>aniso_1</summary>
        Aniso1,
        /// <summary>aniso_2</summary>
        Aniso2,
        /// <summary>aniso_4</summary>
        Aniso4
    }
    #endregion

    #region AttrTexCoordFunc
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexCoordFunc
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>mtx24</summary>
        Mtx24,
        /// <summary>mtx34</summary>
        Mtx34,
        /// <summary>srtg</summary>
        Srtg
    }
    #endregion

    #region AttrTexCoordMtx
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTexCoordMtx
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>texmtx0</summary>
        TexMtx0,
        /// <summary>texmtx1</summary>
        TexMtx1,
        /// <summary>texmtx2</summary>
        TexMtx2,
        /// <summary>texmtx3</summary>
        TexMtx3,
        /// <summary>texmtx4</summary>
        TexMtx4,
        /// <summary>texmtx5</summary>
        TexMtx5,
        /// <summary>texmtx6</summary>
        TexMtx6,
        /// <summary>texmtx7</summary>
        TexMtx7,
        /// <summary>texmtx8</summary>
        TexMtx8,
        /// <summary>texmtx9</summary>
        TexMtx9,
        /// <summary>identity</summary>
        Identity
    }
    #endregion

    #region AttrTextureResourceType
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTextureResourceType
    {
        /// <summary>ファイル</summary>
        LocalFile,
        /// <summary>自分自身のキャプチャテクスチャ</summary>
        LocalCaptured,
        /// <summary>上書きしたレイアウトのキャプチャテクスチャ</summary>
        OverrideCaptured,
    }
    #endregion

    #region AttrIndScale
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrIndScale
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>its_1</summary>
        Its1,
        /// <summary>its_2</summary>
        Its2,
        /// <summary>its_4</summary>
        Its4,
        /// <summary>its_8</summary>
        Its8,
        /// <summary>its_16</summary>
        Its16,
        /// <summary>its_32</summary>
        Its32,
        /// <summary>its_64</summary>
        Its64,
        /// <summary>its_128</summary>
        Its128,
        /// <summary>its_256</summary>
        Its256
    }
    #endregion

    #region AttrSwapArg
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrSwapArg
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>r</summary>
        R,
        /// <summary>g</summary>
        G,
        /// <summary>b</summary>
        B,
        /// <summary>a</summary>
        A
    }
    #endregion

    #region AttrRasOrder
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrRasOrder
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>color_null</summary>
        ColorNull,
        /// <summary>color0a0</summary>
        Color0A0,
        /// <summary>color1a1</summary>
        Color1A1,
        /// <summary>color_zero</summary>
        ColorZero,
    }
    #endregion

    #region AttrTevArg
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevArg
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>c0</summary>
        C0,
        /// <summary>c1</summary>
        C1,
        /// <summary>c2</summary>
        C2,
        /// <summary>cprev</summary>
        CPrev,
        /// <summary>a0</summary>
        A0,
        /// <summary>a1</summary>
        A1,
        /// <summary>a2</summary>
        A2,
        /// <summary>aprev</summary>
        APrev,
        /// <summary>texc</summary>
        TexC,
        /// <summary>texa</summary>
        TexA,
        /// <summary>rasc</summary>
        RasC,
        /// <summary>rasa</summary>
        RasA,
        /// <summary>one</summary>
        One,
        /// <summary>half</summary>
        Half,
        /// <summary>zero</summary>
        Zero,
        /// <summary>konst</summary>
        Konst
    }
    #endregion

    #region AttrTevKSel
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevKSel
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>k0</summary>
        K0,
        /// <summary>k0_r</summary>
        K0R,
        /// <summary>k0_g</summary>
        K0G,
        /// <summary>k0_b</summary>
        K0B,
        /// <summary>k0_a</summary>
        K0A,
        /// <summary>k1</summary>
        K1,
        /// <summary>k1_r</summary>
        K1R,
        /// <summary>k1_g</summary>
        K1G,
        /// <summary>k1_b</summary>
        K1B,
        /// <summary>k1_a</summary>
        K1A,
        /// <summary>k2</summary>
        K2,
        /// <summary>k2_r</summary>
        K2R,
        /// <summary>k2_g</summary>
        K2G,
        /// <summary>k2_b</summary>
        K2B,
        /// <summary>k2_a</summary>
        K2A,
        /// <summary>k3</summary>
        K3,
        /// <summary>k3_r</summary>
        K3R,
        /// <summary>k3_g</summary>
        K3G,
        /// <summary>k3_b</summary>
        K3B,
        /// <summary>k3_a</summary>
        K3A,
        /// <summary>8_8</summary>
        C8_8,
        /// <summary>7_8</summary>
        C7_8,
        /// <summary>6_8</summary>
        C6_8,
        /// <summary>5_8</summary>
        C5_8,
        /// <summary>4_8</summary>
        C4_8,
        /// <summary>3_8</summary>
        C3_8,
        /// <summary>2_8</summary>
        C2_8,
        /// <summary>1_8</summary>
        C1_8
    }
    #endregion

    #region AttrTevBias
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevBias
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>zero</summary>
        Zero,
        /// <summary>add_half</summary>
        AddHalf,
        /// <summary>sub_half</summary>
        SubHalf
    }
    #endregion

    #region AttrTevScale
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevScale
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>scale_1</summary>
        Scale1,
        /// <summary>scale_2</summary>
        Scale2,
        /// <summary>scale_4</summary>
        Scale4,
        /// <summary>divide_2</summary>
        Divide2
    }
    #endregion

    #region AttrTevOutReg
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevOutReg
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>reg0</summary>
        Reg0,
        /// <summary>reg1</summary>
        Reg1,
        /// <summary>reg2</summary>
        Reg2,
        /// <summary>prev</summary>
        Prev
    }
    #endregion

    #region AttrTevIndFormat
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevIndFormat
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>itf_8</summary>
        Itf8,
        /// <summary>itf_5</summary>
        Itf5,
        /// <summary>itf_4</summary>
        Itf4,
        /// <summary>itf_3</summary>
        Itf3
    }
    #endregion

    #region AttrTevIndBias
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevIndBias
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>itb_none</summary>
        ItbNone,
        /// <summary>itb_s</summary>
        ItbS,
        /// <summary>itb_t</summary>
        ItbT,
        /// <summary>itb_u</summary>
        ItbU,
        /// <summary>itb_st</summary>
        ItbST,
        /// <summary>itb_su</summary>
        ItbSU,
        /// <summary>itb_tu</summary>
        ItbTU,
        /// <summary>itb_stu</summary>
        ItbSTU
    }
    #endregion

    #region AttrTevIndMatrix
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevIndMatrix
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>itm_off</summary>
        ItmOff,
        /// <summary>itm_0</summary>
        Itm0,
        /// <summary>itm_1</summary>
        Itm1,
        /// <summary>itm_2</summary>
        Itm2,
        /// <summary>itm_s0</summary>
        ItmS0,
        /// <summary>itm_s1</summary>
        ItmS1,
        /// <summary>itm_s2</summary>
        ItmS2,
        /// <summary>itm_t0</summary>
        ItmT0,
        /// <summary>itm_t1</summary>
        ItmT1,
        /// <summary>itm_t2</summary>
        ItmT2
    }
    #endregion

    #region AttrTevIndWrap
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevIndWrap
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>itw_off</summary>
        ItwOff,
        /// <summary>itw_256</summary>
        Itw256,
        /// <summary>itw_128</summary>
        Itw128,
        /// <summary>itw_64</summary>
        Itw64,
        /// <summary>itw_32</summary>
        Itw32,
        /// <summary>itw_16</summary>
        Itw16,
        /// <summary>itw_0</summary>
        Itw0
    }
    #endregion

    #region AttrTevIndAlpha
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrTevIndAlpha
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>itba_off</summary>
        ItbaOff,
        /// <summary>itba_s</summary>
        ItbaS,
        /// <summary>itba_t</summary>
        ItbaT,
        /// <summary>itba_u</summary>
        ItbaU
    }
    #endregion


    #region AttrCompareFunc
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrCompareFunc
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>never</summary>
        Never,
        /// <summary>less</summary>
        Less,
        /// <summary>lequal</summary>
        Lequal,
        /// <summary>equal</summary>
        Equal,
        /// <summary>nequal</summary>
        Nequal,
        /// <summary>gequal</summary>
        Gequal,
        /// <summary>greater</summary>
        Greater,
        /// <summary>always</summary>
        Always
    }
    #endregion

    #region AttrAlphaOp
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrAlphaOp
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>and</summary>
        And,
        /// <summary>or</summary>
        Or,
        /// <summary>xor</summary>
        Xor,
        /// <summary>xnor</summary>
        Xnor
    }
    #endregion

    #region AttrBlendType
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrBlendType
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>none</summary>
        None,
        /// <summary>blend</summary>
        Blend,
        /// <summary>logic</summary>
        Logic,
        /// <summary>subtract</summary>
        Subtract
    }
    #endregion

    #region AttrBlendFactor
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrBlendFactor
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>zero</summary>
        V0,
        /// <summary>one</summary>
        V1_0,
        /// <summary>dst_color</summary>
        DstClr,
        /// <summary>inv_dst_color</summary>
        InvDstClr,
        /// <summary>src_alpha</summary>
        SrcAlpha,
        /// <summary>inv_src_alpha</summary>
        InvSrcAlpha,
        /// <summary>dst_alpha</summary>
        DstAlpha,
        /// <summary>inv_dst_alpha</summary>
        InvDstAlpha,
        /// <summary>src_color</summary>
        SrcClr,
        /// <summary>inv_src_color</summary>
        InvSrcClr,
    }
    #endregion

    ///
    #region AttrBlendOp
    /// <summary>
    ///
    /// </summary>
    public enum AttrBlendOp
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>add</summary>
        Add,
        /// <summary>sub</summary>
        Subtract,
        /// <summary>inv_sub</summary>
        ReverseSubtract,
        /// <summary>select_min</summary>
        SelectMin,
        /// <summary>select_max</summary>
        SelectMax,
    }
    #endregion

    #region AttrTevSource
    /// <summary>
    /// ソース
    /// </summary>
    public enum AttrTevSource
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary></summary>
        Texture0,
        /// <summary></summary>
        Texture1,
        /// <summary></summary>
        Texture2,
        /// <summary></summary>
        Texture3,
        /// <summary></summary>
        Constant,
        /// <summary></summary>
        Primary,
        /// <summary></summary>
        Previous,
        /// <summary></summary>
        Register,
    }
    #endregion

    #region AttrTevSource
    /// <summary>
    /// オペランド
    /// </summary>
    public enum AttrTevOp
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary></summary>
        Rgb,
        /// <summary></summary>
        InvRgb,
        /// <summary></summary>
        Alpha,
        /// <summary></summary>
        InvAlpha,
        /// <summary></summary>
        Rrr,
        /// <summary></summary>
        InvRrr,
        /// <summary></summary>
        Ggg,
        /// <summary></summary>
        InvGgg,
        /// <summary></summary>
        Bbb,
        /// <summary></summary>
        InvBbb,
        /// <summary></summary>
        R,
        /// <summary></summary>
        InvR,
        /// <summary></summary>
        G,
        /// <summary></summary>
        InvG,
        /// <summary></summary>
        B,
        /// <summary></summary>
        InvB,
    }
    #endregion

    #region AttrBlendOperation
    /// <summary>
    /// ブレンドモード
    /// </summary>
    public enum AttrCombineMode
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary></summary>
        Replace,
        /// <summary></summary>
        Modulate,
        /// <summary></summary>
        Add,
        /// <summary></summary>
        AddSigned,
        /// <summary></summary>
        Interpolate,
        /// <summary></summary>
        Subtract,
        /// <summary></summary>
        AddMultDMP,
        /// <summary></summary>
        MultAddDMP,
        /// <summary></summary>
        Overlay,
        /// <summary></summary>
        Lighten,
        /// <summary></summary>
        Darken,
        /// <summary></summary>
        Indirect,
        /// <summary></summary>
        BlendIndirect,
        /// <summary></summary>
        EachIndirect,
    }
    #endregion

    #region AttrTevKonst
    /// <summary>
    /// コンスタントレジスタ
    /// </summary>
    public enum AttrTevKonst
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>k0</summary>
        K0,
        /// <summary>k1</summary>
        K1,
        /// <summary>k2</summary>
        K2,
        /// <summary>k3</summary>
        K3,
        /// <summary>k4</summary>
        K4,
        /// <summary>k5</summary>
        K5,
        /// <summary>黒カラー</summary>
        BlackColor,
        /// <summary>白カラー</summary>
        WhiteColor
    }
    #endregion

    #region AttrLogicOp
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrLogicOp
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>clear</summary>
        Clear,
        /// <summary>set</summary>
        Set,
        /// <summary>copy</summary>
        Copy,
        /// <summary>inv_copy</summary>
        InvCopy,
        /// <summary>noop</summary>
        Noop,
        /// <summary>inv</summary>
        Inv,
        /// <summary>and</summary>
        And,
        /// <summary>nand</summary>
        Nand,
        /// <summary>or</summary>
        Or,
        /// <summary>nor</summary>
        Nor,
        /// <summary>xor</summary>
        Xor,
        /// <summary>equiv</summary>
        Equiv,
        /// <summary>rev_and</summary>
        RevAnd,
        /// <summary>inv_and</summary>
        InvAnd,
        /// <summary>rev_or</summary>
        RevOr,
        /// <summary>inv_or</summary>
        InvOr
    }
    #endregion

    #region AttrPrimitiveType
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrPrimitiveType
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>points</summary>
        Points,
        /// <summary>line_strip</summary>
        LineStrip,
        /// <summary>triangles</summary>
        Triangles,
        /// <summary>triangle_fan</summary>
        TriangleFan,
        /// <summary>triangle_strip</summary>
        TriangleStrip
    }
    #endregion

    #region AttrDisplayFace
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrDisplayFace
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>front</summary>
        Front,
        /// <summary>back</summary>
        Back,
        /// <summary>both</summary>
        Both
    }
    #endregion

    #region AttrBillboard
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrBillboard
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>off</summary>
        Off,
        /// <summary>std</summary>
        Std,
        /// <summary>persp_std</summary>
        PerspStd,
        /// <summary>rot</summary>
        Rot,
        /// <summary>persp_rot</summary>
        PerspRot,
        /// <summary>y</summary>
        Y,
        /// <summary>persp_y</summary>
        PerspY
    }
    #endregion

    #region AttrUserDataType
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrUserDataType
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>int</summary>
        Int,
        /// <summary>float</summary>
        Float,
        /// <summary>string</summary>
        String
    }
    #endregion

    #region AttrImageFormat
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrImageFormat
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>i4</summary>
        I4,
        /// <summary>ia4</summary>
        IA4,
        /// <summary>i8</summary>
        I8,
        /// <summary>ia8</summary>
        IA8,
        /// <summary>rgb565</summary>
        RGB565,
        /// <summary>rgb5a3</summary>
        RGB5A3,
        /// <summary>rgba8</summary>
        RGBA8,
        /// <summary>cmpr</summary>
        CMPR,
        /// <summary>c4</summary>
        C4,
        /// <summary>c8</summary>
        C8,
        /// <summary>c14</summary>
        C14
    }
    #endregion

    #region AttrImageDataUnit
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrImageDataUnit
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>u8</summary>
        U8,
        /// <summary>u16</summary>
        U16,
        /// <summary>u32</summary>
        U32
    }
    #endregion

    #region AttrPaletteFormat
    /// <summary>
    /// 属性値。
    /// </summary>
    public enum AttrPaletteFormat
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>ia8</summary>
        IA8,
        /// <summary>rgb565</summary>
        RGB565,
        /// <summary>rgb5a3</summary>
        RGB5A3
    }
    #endregion

    #region Attr_frame_precision
    /// <summary>
    /// frame_precision属性値。
    /// </summary>
    public enum Attr_frame_precision
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>1_1</summary>
        C1_1,
        /// <summary>1_2</summary>
        C1_2,
        /// <summary>1_5</summary>
        C1_5,
        /// <summary>1_10</summary>
        C1_10
    }
    #endregion

    #region Attr_node_anim_target
    /// <summary>
    /// node_anim_target属性値。
    /// </summary>
    public enum Attr_node_anim_target
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>scale_x</summary>
        ScaleX,
        /// <summary>scale_y</summary>
        ScaleY,
        /// <summary>scale_z</summary>
        ScaleZ,
        /// <summary>rotate_x</summary>
        RotateX,
        /// <summary>rotate_y</summary>
        RotateY,
        /// <summary>rotate_z</summary>
        RotateZ,
        /// <summary>translate_x</summary>
        TranslateX,
        /// <summary>translate_y</summary>
        TranslateY,
        /// <summary>translate_z</summary>
        TranslateZ
    }
    #endregion

    #region Attr_visibility_anim_target
    /// <summary>
    /// visibility_anim_target属性値。
    /// </summary>
    public enum Attr_visibility_anim_target
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>visibility</summary>
        Visibility
    }
    #endregion

    #region Attr_color_anim_target
    /// <summary>
    /// color_anim_target属性値。
    /// </summary>
    public enum Attr_color_anim_target
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>mat_color0_r</summary>
        MatColor0R,
        /// <summary>mat_color0_g</summary>
        MatColor0G,
        /// <summary>mat_color0_b</summary>
        MatColor0B,
        /// <summary>mat_color0_a</summary>
        MatColor0A,
        /// <summary>mat_color1_r</summary>
        MatColor1R,
        /// <summary>mat_color1_g</summary>
        MatColor1G,
        /// <summary>mat_color1_b</summary>
        MatColor1B,
        /// <summary>mat_color1_a</summary>
        MatColor1A,
        /// <summary>amb_color0_r</summary>
        AmbColor0R,
        /// <summary>amb_color0_g</summary>
        AmbColor0G,
        /// <summary>amb_color0_b</summary>
        AmbColor0B,
        /// <summary>amb_color0_a</summary>
        AmbColor0A,
        /// <summary>amb_color1_r</summary>
        AmbColor1R,
        /// <summary>amb_color1_g</summary>
        AmbColor1G,
        /// <summary>amb_color1_b</summary>
        AmbColor1B,
        /// <summary>amb_color1_a</summary>
        AmbColor1A,
        /// <summary>tev_color0_r</summary>
        TevColor0R,
        /// <summary>tev_color0_g</summary>
        TevColor0G,
        /// <summary>tev_color0_b</summary>
        TevColor0B,
        /// <summary>tev_color0_a</summary>
        TevColor0A,
        /// <summary>tev_color1_r</summary>
        TevColor1R,
        /// <summary>tev_color1_g</summary>
        TevColor1G,
        /// <summary>tev_color1_b</summary>
        TevColor1B,
        /// <summary>tev_color1_a</summary>
        TevColor1A,
        /// <summary>tev_color2_r</summary>
        TevColor2R,
        /// <summary>tev_color2_g</summary>
        TevColor2G,
        /// <summary>tev_color2_b</summary>
        TevColor2B,
        /// <summary>tev_color2_a</summary>
        TevColor2A,
        /// <summary>tev_constant0_r</summary>
        TevConstant0R,
        /// <summary>tev_constant0_g</summary>
        TevConstant0G,
        /// <summary>tev_constant0_b</summary>
        TevConstant0B,
        /// <summary>tev_constant0_a</summary>
        TevConstant0A,
        /// <summary>tev_constant1_r</summary>
        TevConstant1R,
        /// <summary>tev_constant1_g</summary>
        TevConstant1G,
        /// <summary>tev_constant1_b</summary>
        TevConstant1B,
        /// <summary>tev_constant1_a</summary>
        TevConstant1A,
        /// <summary>tev_constant2_r</summary>
        TevConstant2R,
        /// <summary>tev_constant2_g</summary>
        TevConstant2G,
        /// <summary>tev_constant2_b</summary>
        TevConstant2B,
        /// <summary>tev_constant2_a</summary>
        TevConstant2A,
        /// <summary>tev_constant3_r</summary>
        TevConstant3R,
        /// <summary>tev_constant3_g</summary>
        TevConstant3G,
        /// <summary>tev_constant3_b</summary>
        TevConstant3B,
        /// <summary>tev_constant3_a</summary>
        TevConstant3A
    }
    #endregion

    #region Attr_tex_pattern_anim_target
    /// <summary>
    /// tex_pattern_anim_target属性値。
    /// </summary>
    public enum Attr_tex_pattern_anim_target
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>image</summary>
        Image,
        /// <summary>palette</summary>
        Palette
    }
    #endregion

    #region Attr_tex_srt_anim_target
    /// <summary>
    /// tex_srt_anim_target属性値。
    /// </summary>
    public enum Attr_tex_srt_anim_target
    {
        /// <summary>不明</summary>
        _Unknown = -1,
        /// <summary>tex_scale_s</summary>
        TexScaleS,
        /// <summary>tex_scale_t</summary>
        TexScaleT,
        /// <summary>tex_rotate</summary>
        TexRotate,
        /// <summary>tex_translate_s</summary>
        TexTranslateS,
        /// <summary>tex_translate_t</summary>
        TexTranslateT
    }
    #endregion
}


namespace LECore.Structures.Nsrif.Elements
{
    using Nsrif.Attributes;
    /// <summary>
    /// 要素クラス。
    /// </summary>
    public abstract class Element
    {
        // 共通操作用
        // 今のところ特になし
    }

    /// <summary>
    /// アニメーションデータ要素クラス。
    /// </summary>
    public abstract class AnimDataElement : Element
    {
        /// <summary>
        /// タイプ名。
        /// </summary>
        public abstract string TypeName { get; }
    }

    // 構成データ

    #region NsrifXyz
    /// <summary>
    /// xyzデータクラス。
    /// </summary>
    public class NsrifXyz
    {
        /// <summary>x成分</summary>
        public float x = 0.0f;
        /// <summary>y成分</summary>
        public float y = 0.0f;
        /// <summary>z成分</summary>
        public float z = 0.0f;
    }
    #endregion

    #region NsrifRgba
    /// <summary>
    /// rgbaデータクラス。
    /// </summary>
    public class NsrifRgba
    {
        /// <summary>r成分</summary>
        public int r = 255;
        /// <summary>g成分</summary>
        public int g = 255;
        /// <summary>b成分</summary>
        public int b = 255;
        /// <summary>a成分</summary>
        public int a = 255;
    }
    #endregion

    #region NsrifUv
    /// <summary>
    /// uvデータクラス。
    /// </summary>
    public class NsrifUv
    {
        /// <summary>u成分</summary>
        public float u = 0.0f;
        /// <summary>v成分</summary>
        public float v = 0.0f;
    }
    #endregion

    #region NsrifSwap
    /// <summary>
    /// スワップテーブルデータクラス。
    /// </summary>
    public class NsrifSwap
    {
        /// <summary>rスワップ</summary>
        public AttrSwapArg r = AttrSwapArg.R;
        /// <summary>gスワップ</summary>
        public AttrSwapArg g = AttrSwapArg.G;
        /// <summary>bスワップ</summary>
        public AttrSwapArg b = AttrSwapArg.B;
        /// <summary>aスワップ</summary>
        public AttrSwapArg a = AttrSwapArg.A;
    }
    #endregion

    #region NsrifFv
    /// <summary>
    /// frame,valueデータクラス。
    /// </summary>
    public class NsrifFv
    {
        /// <summary>frame</summary>
        public float f = 0.0f;
        /// <summary>value</summary>
        public float v = 0.0f;
    }
    #endregion

    #region NsrifFvs
    /// <summary>
    /// frame,value,slopeデータクラス。
    /// </summary>
    public class NsrifFvs
    {
        /// <summary>frame</summary>
        public float f = 0.0f;
        /// <summary>value</summary>
        public float v = 0.0f;
        /// <summary>slope</summary>
        public float s = 0.0f;
    }
    #endregion

    // 共通要素

    #region <head>
    /// <summary>
    /// head要素クラス。
    /// </summary>
    public class Elem_head : Element
    {
        /// <summary>子要素</summary>
        public Elem_create		create = new Elem_create();
        /// <summary>子要素</summary>
        public Elem_title		title = new Elem_title();
        /// <summary>子要素</summary>
        public Elem_comment		comment = new Elem_comment();
        /// <summary>子要素</summary>
        public Elem_generator	generator = new Elem_generator();
    }
    #endregion

    #region <create>
    /// <summary>
    /// create要素クラス。
    /// </summary>
    public class Elem_create : Element
    {
        /// <summary>属性</summary>
        public string	user = "";
        /// <summary>属性</summary>
        public string	host = "";
        /// <summary>属性</summary>
        public string	date = "";
        /// <summary>属性</summary>
        public string	source = "";
    }
    #endregion

    #region <title>
    /// <summary>
    /// title要素クラス。
    /// </summary>
    public class Elem_title : Element
    {
        /// <summary>要素内容</summary>
        public string	contents = "";
    }
    #endregion

    #region <comment>
    /// <summary>
    /// comment要素クラス。
    /// </summary>
    public class Elem_comment : Element
    {
        /// <summary>要素内容</summary>
        public string	contents = "";
    }
    #endregion

    #region <generator>
    /// <summary>
    /// generator要素クラス。
    /// </summary>
    public class Elem_generator : Element
    {
        /// <summary>属性</summary>
        public string	name = "";
        /// <summary>属性</summary>
        public string	version = "";
    }
    #endregion

    #region <body>
    /// <summary>
    /// body要素クラス。
    /// </summary>
    public class Elem_body : Element
    {
        /// <summary>子要素</summary>
        public ArrayList	nsrifObjects = new ArrayList();
    }
    #endregion

    #region <file_log_array>
    /// <summary>
    /// file_log_array要素クラス。
    /// </summary>
    public class Elem_file_log_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	file_log = new ArrayList();
    }
    #endregion

    #region <file_log>
    /// <summary>
    /// file_log要素クラス。
    /// </summary>
    public class Elem_file_log : Element
    {
        /// <summary>属性</summary>
        public int		index = 0;
        /// <summary>属性</summary>
        public string	user = "";
        /// <summary>属性</summary>
        public string	host = "";
        /// <summary>属性</summary>
        public string	date = "";
        /// <summary>属性</summary>
        public string	name = "";
        /// <summary>属性</summary>
        public string	version = "";
        /// <summary>要素内容</summary>
        public string[]	contents;
    }
    #endregion

    // アニメーション共通要素

    #region <anim_constant>
    /// <summary>
    /// anim_constant要素クラス。
    /// </summary>
    public class Elem_anim_constant : AnimDataElement
    {
        /// <summary>属性</summary>
        public float	value = 0.0f;

        /// <summary>
        /// オーバーライドプロパティ。
        /// </summary>
        public override string TypeName
        {
            get { return "constant"; }
        }
    }
    #endregion

    #region <anim_step>
    /// <summary>
    /// anim_step要素クラス。
    /// </summary>
    public class Elem_anim_step : AnimDataElement
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>要素内容</summary>
        public NsrifFv[]	contents;

        /// <summary>
        /// オーバーライドプロパティ。
        /// </summary>
        public override string TypeName
        {
            get { return "step"; }
        }
    }
    #endregion

    #region <anim_hermite>
    /// <summary>
    /// anim_hermite要素クラス。
    /// </summary>
    public class Elem_anim_hermite : AnimDataElement
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>要素内容</summary>
        public NsrifFvs[]	contents;

        /// <summary>
        /// オーバーライドプロパティ。
        /// </summary>
        public override string TypeName
        {
            get { return "hermite"; }
        }
    }
    #endregion

    // rmdl要素

    #region <model_info>
    /// <summary>
    /// model_info要素クラス。
    /// </summary>
    public class Elem_model_info : Element
    {
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public float				magnify = 0.0f;
        /// <summary>属性</summary>
        public AttrScalingRule		scaling_rule = AttrScalingRule._Unknown;
        /// <summary>属性</summary>
        public AttrTexMatrixMode	tex_matrix_mode = AttrTexMatrixMode._Unknown;
        /// <summary>属性</summary>
        public int					tool_node_size = 0;
        /// <summary>属性</summary>
        public int					node_size = 0;
        /// <summary>属性</summary>
        public int					tool_material_size = 0;
        /// <summary>属性</summary>
        public int					material_size = 0;
    }
    #endregion

    #region <vtx_position_array>
    /// <summary>
    /// vtx_position_array要素クラス。
    /// </summary>
    public class Elem_vtx_position_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	vtx_position = new ArrayList();
    }
    #endregion

    #region <vtx_position>
    /// <summary>
    /// vtx_position要素クラス。
    /// </summary>
    public class Elem_vtx_position : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public int					size = 0;
        /// <summary>属性</summary>
        public AttrCoordQuantize	quantize = AttrCoordQuantize._Unknown;
        /// <summary>属性</summary>
        public NsrifXyz				min = new NsrifXyz();
        /// <summary>属性</summary>
        public NsrifXyz				max = new NsrifXyz();
        /// <summary>要素内容</summary>
        public NsrifXyz[]			contents;
    }
    #endregion

    #region <vtx_normal_array>
    /// <summary>
    /// vtx_normal_array要素クラス。
    /// </summary>
    public class Elem_vtx_normal_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	vtx_normal = new ArrayList();
    }
    #endregion

    #region <vtx_normal>
    /// <summary>
    /// vtx_normal要素クラス。
    /// </summary>
    public class Elem_vtx_normal : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public int					size = 0;
        /// <summary>属性</summary>
        public AttrNormalQuantize	quantize = AttrNormalQuantize._Unknown;
        /// <summary>要素内容</summary>
        public NsrifXyz[]			contents;
    }
    #endregion

    #region <vtx_color_array>
    /// <summary>
    /// vtx_color_array要素クラス。
    /// </summary>
    public class Elem_vtx_color_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	vtx_color = new ArrayList();
    }
    #endregion

    #region <vtx_color>
    /// <summary>
    /// vtx_color要素クラス。
    /// </summary>
    public class Elem_vtx_color : Element
    {
        /// <summary>属性</summary>
        public int				index = 0;
        /// <summary>属性</summary>
        public int				size = 0;
        /// <summary>属性</summary>
        public AttrColorType	color_type = AttrColorType._Unknown;
        /// <summary>要素内容</summary>
        public NsrifRgba[]		contents;

        /// <summary>
        /// RGB成分のみかどうか。
        /// </summary>
        public bool IsRgbOnly
        {
            get { return color_type == AttrColorType.Rgb565 || color_type == AttrColorType.Rgb8; }
        }
    }
    #endregion

    #region <vtx_tex_coord_array>
    /// <summary>
    /// vtx_tex_coord_array要素クラス。
    /// </summary>
    public class Elem_vtx_tex_coord_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	vtx_tex_coord = new ArrayList();
    }
    #endregion

    #region <vtx_tex_coord>
    /// <summary>
    /// vtx_tex_coord要素クラス。
    /// </summary>
    public class Elem_vtx_tex_coord : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public int					size = 0;
        /// <summary>属性</summary>
        public AttrCoordQuantize	quantize = AttrCoordQuantize._Unknown;
        /// <summary>属性</summary>
        public NsrifUv				min = new NsrifUv();
        /// <summary>属性</summary>
        public NsrifUv				max = new NsrifUv();
        /// <summary>要素内容</summary>
        public NsrifUv[]			contents;
    }
    #endregion

    #region <material_array>
    /// <summary>
    /// material_array要素クラス。
    /// </summary>
    public class Elem_material_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	material = new ArrayList();
    }
    #endregion

    #region <material>
    /// <summary>
    /// material要素クラス。
    /// </summary>
    public class Elem_material : Element
    {
        /// <summary>属性</summary>
        public int							index = 0;
        /// <summary>属性</summary>
        public string						name = "";
        /// <summary>属性</summary>
        public NsrifRgba					mat_color0 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					amb_color0 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					mat_color1 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					amb_color1 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_color0 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_color1 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_color2 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_constant0 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_constant1 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_constant2 = new NsrifRgba();
        /// <summary>属性</summary>
        public NsrifRgba					tev_constant3 = new NsrifRgba();
        /// <summary>属性</summary>
        public bool							tev_share_enable = false;
        /// <summary>属性</summary>
        public int							hold_vtx_normal = 0;
        /// <summary>属性</summary>
        public int							hold_vtx_color = 0;
        /// <summary>属性</summary>
        public int							hold_vtx_tex_coord = 0;
        /// <summary>属性</summary>
        public AttrTransparencyMode			transparency_mode = AttrTransparencyMode._Unknown;
        /// <summary>属性</summary>
        public bool							compress_enable = false;
        /// <summary>子要素</summary>
        public Elem_color_assign_array		color_assign_array = new Elem_color_assign_array();
        /// <summary>子要素</summary>
        public Elem_chan_ctrl_array			chan_ctrl_array = new Elem_chan_ctrl_array();
        /// <summary>子要素</summary>
        public Elem_tex_map_array			tex_map_array = new Elem_tex_map_array();
        /// <summary>子要素</summary>
        public Elem_tex_coord_array			tex_coord_array = new Elem_tex_coord_array();
        /// <summary>子要素</summary>
        public Elem_tex_matrix_array		tex_matrix_array = new Elem_tex_matrix_array();
        /// <summary>子要素</summary>
        public Elem_indirect_matrix_array	indirect_matrix_array = new Elem_indirect_matrix_array();
        /// <summary>子要素</summary>
        public Elem_indirect_stage_array	indirect_stage_array = new Elem_indirect_stage_array();
        /// <summary>子要素</summary>
        public Elem_tev_stage_array			tev_stage_array = new Elem_tev_stage_array();
        /// <summary>子要素</summary>
        public Elem_alpha_compare			alpha_compare = new Elem_alpha_compare();
        /// <summary>子要素</summary>
        public Elem_z_compare				z_compare = new Elem_z_compare();
        /// <summary>子要素</summary>
        public Elem_blend_mode				blend_mode = new Elem_blend_mode();
        /// <summary>子要素</summary>
        public Elem_user_data_array			user_data_array = new Elem_user_data_array();
    }
    #endregion

    #region <color_assign_array>
    /// <summary>
    /// color_assign_array要素クラス。
    /// </summary>
    public class Elem_color_assign_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	color_assign = new ArrayList();
    }
    #endregion

    #region <color_assign>
    /// <summary>
    /// color_assign要素クラス。
    /// </summary>
    public class Elem_color_assign : Element
    {
        /// <summary>属性</summary>
        public int						index = 0;
        /// <summary>属性</summary>
        public AttrColorAssignName		name = AttrColorAssignName._Unknown;
        /// <summary>属性</summary>
        public AttrColorAssignTarget	target = AttrColorAssignTarget._Unknown;
    }
    #endregion

    #region <chan_ctrl_array>
    /// <summary>
    /// chan_ctrl_array要素クラス。
    /// </summary>
    public class Elem_chan_ctrl_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	chan_ctrl = new ArrayList();
    }
    #endregion

    #region <chan_ctrl>
    /// <summary>
    /// chan_ctrl要素クラス。
    /// </summary>
    public class Elem_chan_ctrl : Element
    {
        /// <summary>属性</summary>
        public int				index = 0;
        /// <summary>属性</summary>
        public AttrChannel		channel = AttrChannel._Unknown;
        /// <summary>属性</summary>
        public bool				light_enable = false;
        /// <summary>属性</summary>
        public AttrColorSource	ambient_source = AttrColorSource._Unknown;
        /// <summary>属性</summary>
        public AttrColorSource	material_source = AttrColorSource._Unknown;
        /// <summary>属性</summary>
        public AttrDiffuseFunc	diffuse_func = AttrDiffuseFunc._Unknown;
        /// <summary>属性</summary>
        public AttrAttnFunc		attn_func = AttrAttnFunc._Unknown;
    }
    #endregion

    #region <tex_map_array>
    /// <summary>
    /// tex_map_array要素クラス。
    /// </summary>
    public class Elem_tex_map_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_map = new ArrayList();
    }
    #endregion

    #region <tex_map>
    /// <summary>
    /// tex_map要素クラス。
    /// </summary>
    public class Elem_tex_map : Element
    {
        /// <summary>属性</summary>
        public int				index = 0;
        /// <summary>属性</summary>
        public string			image_name = "";
        /// <summary>属性</summary>
        public string			palette_name = "";
        /// <summary>属性</summary>
        public AttrTexWrap		wrap_s = AttrTexWrap._Unknown;
        /// <summary>属性</summary>
        public AttrTexWrap		wrap_t = AttrTexWrap._Unknown;
        /// <summary>属性</summary>
        public bool				mipmap = false;
        /// <summary>属性</summary>
        public AttrTexFilterMin	filter_min = AttrTexFilterMin._Unknown;
        /// <summary>属性</summary>
        public AttrTexFilterMag	filter_mag = AttrTexFilterMag._Unknown;
        /// <summary>属性</summary>
        public float			lod_bias = 0.0f;
        /// <summary>属性</summary>
        public bool				bias_clamp = false;
        /// <summary>属性</summary>
        public bool				do_edge_lod = false;
        /// <summary>属性</summary>
        public AttrMaxAniso		max_aniso = AttrMaxAniso._Unknown;
        /// <summary>属性</summary>
        public int				tex_map_id = 0;
    }
    #endregion

    #region <tex_coord_array>
    /// <summary>
    /// tex_coord_array要素クラス。
    /// </summary>
    public class Elem_tex_coord_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_coord = new ArrayList();
    }
    #endregion

    #region <tex_coord>
    /// <summary>
    /// tex_coord要素クラス。
    /// </summary>
    public class Elem_tex_coord : Element
    {
        /// <summary>属性</summary>
        public int				index = 0;
        /// <summary>属性</summary>
        public AttrTexCoordFunc	func = AttrTexCoordFunc._Unknown;
        ///// <summary>属性</summary>
        public LETexGenMethod src_param = LETexGenMethod.UV0;
        /// <summary>属性</summary>
        public AttrTexCoordMtx	mtx = AttrTexCoordMtx._Unknown;
    }
    #endregion

    #region <tex_matrix_array>
    /// <summary>
    /// tex_matrix_array要素クラス。
    /// </summary>
    public class Elem_tex_matrix_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_matrix = new ArrayList();
    }
    #endregion

    #region <tex_matrix>
    /// <summary>
    /// tex_matrix要素クラス。
    /// </summary>
    public class Elem_tex_matrix : Element
    {
        /// <summary>属性</summary>
        public int		index = 0;
        /// <summary>属性</summary>
        public float[]	tex_scale = new float[2];
        /// <summary>属性</summary>
        public float	tex_rotate = 0.0f;
        /// <summary>属性</summary>
        public float[]	tex_translate = new float[2];
        /// <summary>属性</summary>
        public float[]	tex_effect_mtx0 = new float[16];
        /// <summary>属性</summary>
        public float[]	tex_effect_mtx1 = new float[16];
    }
    #endregion

    #region <indirect_matrix_array>
    /// <summary>
    /// indirect_matrix_array要素クラス。
    /// </summary>
    public class Elem_indirect_matrix_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	indirect_matrix = new ArrayList();
    }
    #endregion

    #region <indirect_matrix>
    /// <summary>
    /// indirect_matrix要素クラス。
    /// </summary>
    public class Elem_indirect_matrix : Element
    {
        /// <summary>属性</summary>
        public int		index = 0;
        /// <summary>属性</summary>
        public float[]	offset_mtx = new float[6];
        /// <summary>属性</summary>
        public int		scale_exp = 1;
    }
    #endregion

    #region <indirect_stage_array>
    /// <summary>
    /// indirect_stage_array要素クラス。
    /// </summary>
    public class Elem_indirect_stage_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	indirect_stage = new ArrayList();
    }
    #endregion

    #region <indirect_stage>
    /// <summary>
    /// indirect_stage要素クラス。
    /// </summary>
    public class Elem_indirect_stage : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public int			tex_map = 0;
        /// <summary>属性</summary>
        public int			tex_coord = 0;
        /// <summary>属性</summary>
        public AttrIndScale	scale_s = AttrIndScale._Unknown;
        /// <summary>属性</summary>
        public AttrIndScale	scale_t = AttrIndScale._Unknown;
    }
    #endregion

    #region <tev_stage_array>
    /// <summary>
    /// tev_stage_array要素クラス。
    /// </summary>
    public class Elem_tev_stage_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>属性</summary>
        public NsrifSwap	swap_table0 = new NsrifSwap();
        /// <summary>属性</summary>
        public NsrifSwap	swap_table1 = new NsrifSwap();
        /// <summary>属性</summary>
        public NsrifSwap	swap_table2 = new NsrifSwap();
        /// <summary>属性</summary>
        public NsrifSwap	swap_table3 = new NsrifSwap();
        /// <summary>子要素</summary>
        public ArrayList	tev_stage = new ArrayList();
    }
    #endregion

    #region <tev_stage>
    /// <summary>
    /// tev_stage要素クラス。
    /// </summary>
    public class Elem_tev_stage : Element
    {
        /// <summary>属性</summary>
        public int						index = 0;
        /// <summary>属性</summary>
        public AttrRasOrder				ras_order = AttrRasOrder._Unknown;
        /// <summary>属性</summary>
        public int						tex_map_order = -1;
        /// <summary>属性</summary>
        public int						tex_coord_order = -1;
        /// <summary>属性</summary>
        public int						ras_swap = 0;
        /// <summary>属性</summary>
        public int						tex_map_swap = 0;
        /// <summary>子要素</summary>
        public Elem_tev_stage_direct	tev_stage_color = new Elem_tev_stage_direct();
        /// <summary>子要素</summary>
        public Elem_tev_stage_direct	tev_stage_alpha = new Elem_tev_stage_direct();
        /// <summary>子要素</summary>
        public Elem_tev_stage_indirect	tev_stage_indirect = new Elem_tev_stage_indirect();
    }
    #endregion

    #region <tev_stage_direct>
    /// <summary>
    /// tev_stage_direct要素クラス。
    /// </summary>
    public class Elem_tev_stage_direct : Element
    {
        /// <summary>属性</summary>
        public AttrTevArg		a = AttrTevArg._Unknown;
        /// <summary>属性</summary>
        public AttrTevArg		b = AttrTevArg._Unknown;
        /// <summary>属性</summary>
        public AttrTevArg		c = AttrTevArg._Unknown;
        /// <summary>属性</summary>
        public AttrTevArg		d = AttrTevArg._Unknown;
        /// <summary>属性</summary>
        public AttrTevKSel		constant = AttrTevKSel._Unknown;
        /// <summary>属性</summary>
        public AttrTevOp		op = AttrTevOp._Unknown;
        /// <summary>属性</summary>
        public AttrTevBias		bias = AttrTevBias._Unknown;
        /// <summary>属性</summary>
        public AttrTevScale		scale = AttrTevScale._Unknown;
        /// <summary>属性</summary>
        public bool				clamp = false;
        /// <summary>属性</summary>
        public AttrTevOutReg	out_reg = AttrTevOutReg._Unknown;
    }
    #endregion

    #region <tev_stage_indirect>
    /// <summary>
    /// tev_stage_indirect要素クラス。
    /// </summary>
    public class Elem_tev_stage_indirect : Element
    {
        /// <summary>属性</summary>
        public int				ind_stage = 0;
        /// <summary>属性</summary>
        public AttrTevIndFormat	format = AttrTevIndFormat._Unknown;
        /// <summary>属性</summary>
        public AttrTevIndBias	bias_sel = AttrTevIndBias._Unknown;
        /// <summary>属性</summary>
        public AttrTevIndMatrix	matrix_sel = AttrTevIndMatrix._Unknown;
        /// <summary>属性</summary>
        public AttrTevIndWrap	wrap_s = AttrTevIndWrap._Unknown;
        /// <summary>属性</summary>
        public AttrTevIndWrap	wrap_t = AttrTevIndWrap._Unknown;
        /// <summary>属性</summary>
        public bool				add_prev = false;
        /// <summary>属性</summary>
        public bool				utc_lod = false;
        /// <summary>属性</summary>
        public AttrTevIndAlpha	alpha_sel = AttrTevIndAlpha._Unknown;
    }
    #endregion

    #region <alpha_compare>
    /// <summary>
    /// alpha_compare要素クラス。
    /// </summary>
    public class Elem_alpha_compare : Element
    {
        /// <summary>属性</summary>
        public AttrCompareFunc	comp0 = AttrCompareFunc._Unknown;
        /// <summary>属性</summary>
        public int				ref0 = 0;
        /// <summary>属性</summary>
        public AttrAlphaOp		op = AttrAlphaOp._Unknown;
        /// <summary>属性</summary>
        public AttrCompareFunc	comp1 = AttrCompareFunc._Unknown;
        /// <summary>属性</summary>
        public int				ref1 = 0;
    }
    #endregion

    #region <z_compare>
    /// <summary>
    /// z_compare要素クラス。
    /// </summary>
    public class Elem_z_compare : Element
    {
        /// <summary>属性</summary>
        public bool				enable = false;
        /// <summary>属性</summary>
        public AttrCompareFunc	func = AttrCompareFunc._Unknown;
        /// <summary>属性</summary>
        public bool				update = false;
        /// <summary>属性</summary>
        public bool				before_tex = false;
    }
    #endregion

    #region <blend_mode>
    /// <summary>
    /// blend_mode要素クラス。
    /// </summary>
    public class Elem_blend_mode : Element
    {
        /// <summary>属性</summary>
        public AttrBlendType	type = AttrBlendType._Unknown;
        /// <summary>属性</summary>
        public AttrBlendFactor	src_factor = AttrBlendFactor._Unknown;
        /// <summary>属性</summary>
        public AttrBlendFactor	dst_factor = AttrBlendFactor._Unknown;
        /// <summary>属性</summary>
        public AttrLogicOp		op = AttrLogicOp._Unknown;
    }
    #endregion

    #region <matrix_array>
    /// <summary>
    /// matrix_array要素クラス。
    /// </summary>
    public class Elem_matrix_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	matrix = new ArrayList();
    }
    #endregion

    #region <matrix>
    /// <summary>
    /// matrix要素クラス。
    /// </summary>
    public class Elem_matrix : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public int			matrix_weight_size = 0;
        /// <summary>子要素</summary>
        public ArrayList	matrix_weight = new ArrayList();
    }
    #endregion

    #region <matrix_weight>
    /// <summary>
    /// matrix_weight要素クラス。
    /// </summary>
    public class Elem_matrix_weight : Element
    {
        /// <summary>属性</summary>
        public int	node_index = 0;
        /// <summary>属性</summary>
        public int	weight = 0;
    }
    #endregion

    #region <polygon_array>
    /// <summary>
    /// polygon_array要素クラス。
    /// </summary>
    public class Elem_polygon_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	polygon = new ArrayList();
    }
    #endregion

    #region <polygon>
    /// <summary>
    /// polygon要素クラス。
    /// </summary>
    public class Elem_polygon : Element
    {
        /// <summary>属性</summary>
        public int							index = 0;
        /// <summary>属性</summary>
        public string						name = "";
        /// <summary>属性</summary>
        public AttrPrimitiveType			primitive_type = AttrPrimitiveType._Unknown;
        /// <summary>属性</summary>
        public AttrDisplayFace				display_face = AttrDisplayFace._Unknown;
        /// <summary>属性</summary>
        public int							vertex_size = 0;
        /// <summary>属性</summary>
        public int							triangle_size = 0;
        /// <summary>属性</summary>
        public int							current_matrix = -1;
        /// <summary>属性</summary>
        public int[]						vcd_set = new int[21];
        /// <summary>属性</summary>
        public int							vtx_position_index = -1;
        /// <summary>属性</summary>
        public int							vtx_normal_index = -1;
        /// <summary>属性</summary>
        public int[]						vtx_color_index = new int[2];
        /// <summary>属性</summary>
        public int[]						vtx_tex_coord_index = new int[8];
        /// <summary>子要素</summary>
        public Elem_matrix_primitive_array	matrix_primitive_array = new Elem_matrix_primitive_array();

        /// <summary>
        /// vcd_setの有効なインデクスリストを取得。
        /// </summary>
        public int[] GetVcdEnableIdxList()
        {
            // 有効数カウント
            int count = 0;
            foreach (int val in vcd_set)
            {
                if (val == 1)
                {
                    count++;
                }
            }

            // リスト作成
            int[] list = new int[count];
            for (int i = 0, j = 0; i < vcd_set.Length; i++)
            {
                if (vcd_set[i] == 1)
                {
                    list[j] = i;
                    j++;
                }
            }
            return list;
        }
    }
    #endregion

    #region <matrix_primitive_array>
    /// <summary>
    /// matrix_primitive_array要素クラス。
    /// </summary>
    public class Elem_matrix_primitive_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	matrix_primitive = new ArrayList();
    }
    #endregion

    #region <matrix_primitive>
    /// <summary>
    /// matrix_primitive要素クラス。
    /// </summary>
    public class Elem_matrix_primitive : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public int[]				matrix_list = new int[10];
        /// <summary>子要素</summary>
        public Elem_primitive_array	primitive_array = new Elem_primitive_array();
    }
    #endregion

    #region <primitive_array>
    /// <summary>
    /// primitive_array要素クラス。
    /// </summary>
    public class Elem_primitive_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	primitive = new ArrayList();
    }
    #endregion

    #region <primitive>
    /// <summary>
    /// primitive要素クラス。
    /// </summary>
    public class Elem_primitive : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public int					size = 0;
        /// <summary>属性</summary>
        public AttrPrimitiveType	primitive_type = AttrPrimitiveType._Unknown;
        /// <summary>要素内容</summary>
        public int[][]				contents;
    }
    #endregion

    #region <node_array>
    /// <summary>
    /// node_array要素クラス。
    /// </summary>
    public class Elem_node_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	node = new ArrayList();
    }
    #endregion

    #region <node>
    /// <summary>
    /// node要素クラス。
    /// </summary>
    public class Elem_node : Element
    {
        /// <summary>属性</summary>
        public int					index = 0;
        /// <summary>属性</summary>
        public string				name = "";
        /// <summary>属性</summary>
        public int					parent = -1;
        /// <summary>属性</summary>
        public int					child = -1;
        /// <summary>属性</summary>
        public int					sibling_next = -1;
        /// <summary>属性</summary>
        public int					sibling_prev = -1;
        /// <summary>属性</summary>
        public NsrifXyz				scale = new NsrifXyz();
        /// <summary>属性</summary>
        public NsrifXyz				rotate = new NsrifXyz();
        /// <summary>属性</summary>
        public NsrifXyz				translate = new NsrifXyz();
        /// <summary>属性</summary>
        public NsrifXyz				volume_min = new NsrifXyz();
        /// <summary>属性</summary>
        public NsrifXyz				volume_max = new NsrifXyz();
        /// <summary>属性</summary>
        public bool					scale_compensate = false;
        /// <summary>属性</summary>
        public bool					display_matrix = false;
        /// <summary>属性</summary>
        public bool					envelope_matrix = false;
        /// <summary>属性</summary>
        public bool					compress_enable = false;
        /// <summary>属性</summary>
        public AttrBillboard		billboard = AttrBillboard._Unknown;
        /// <summary>属性</summary>
        public bool					visibility = false;
        /// <summary>子要素</summary>
        public Elem_display_array	display_array = new Elem_display_array();
        /// <summary>子要素</summary>
        public Elem_user_data_array	user_data_array = new Elem_user_data_array();
    }
    #endregion

    #region <display_array>
    /// <summary>
    /// display_array要素クラス。
    /// </summary>
    public class Elem_display_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>属性</summary>
        public int			triangle_size = 0;
        /// <summary>子要素</summary>
        public ArrayList	display = new ArrayList();
    }
    #endregion

    #region <display>
    /// <summary>
    /// display要素クラス。
    /// </summary>
    public class Elem_display : Element
    {
        /// <summary>属性</summary>
        public int	index = 0;
        /// <summary>属性</summary>
        public int	material_index = 0;
        /// <summary>属性</summary>
        public int	polygon_index = 0;
        /// <summary>属性</summary>
        public int	priority = 0;
    }
    #endregion

    #region <extra_info>
    /// <summary>
    /// extra_info要素クラス。
    /// </summary>
    public class Elem_extra_info : Element
    {
        /// <summary>属性</summary>
        public int	tool_vertex_size = 0;
        /// <summary>属性</summary>
        public int	vertex_size = 0;
        /// <summary>属性</summary>
        public int	triangle_size = 0;
    }
    #endregion

    #region <user_data_array>
    /// <summary>
    /// user_data_array要素クラス。
    /// </summary>
    public class Elem_user_data_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	user_data = new ArrayList();
    }
    #endregion

    #region <user_data>
    /// <summary>
    /// user_data要素クラス。
    /// </summary>
    public class Elem_user_data : Element
    {
        /// <summary>属性</summary>
        public int				index = 0;
        /// <summary>属性</summary>
        public string			name = "";
        /// <summary>属性</summary>
        public AttrUserDataType	user_data_type = AttrUserDataType._Unknown;
        /// <summary>属性</summary>
        public int				size = 0;
        /// <summary>要素内容</summary>
        public int[]			contents_int = null;
        /// <summary>要素内容</summary>
        public float[]			contents_float = null;
        /// <summary>要素内容</summary>
        public string			contents_string = null;
    }
    #endregion

    // rtex要素

    #region <image>
    /// <summary>
    /// image要素クラス。
    /// </summary>
    public class Elem_image : Element
    {
        /// <summary>属性</summary>
        public AttrImageFormat		format = AttrImageFormat._Unknown;
        /// <summary>属性</summary>
        public string				palette_name = "";
        /// <summary>属性</summary>
        public int					width = 0;
        /// <summary>属性</summary>
        public int					height = 0;
        /// <summary>属性</summary>
        public int					mipmap_level = 0;
        /// <summary>属性</summary>
        public AttrImageDataUnit	data_unit = AttrImageDataUnit._Unknown;
        /// <summary>属性</summary>
        public int					data_size = 0;
        /// <summary>属性</summary>
        public string				path = "";
        /// <summary>要素内容</summary>
        public byte[]				contents_u8;
        /// <summary>要素内容</summary>
        public ushort[]				contents_u16;
        /// <summary>要素内容</summary>
        public uint[]				contents_u32;

        /// <summary>
        /// CIフォーマットかどうか。
        /// </summary>
        public bool IsCIFormat
        {
            get
            {
                return
                    format == AttrImageFormat.C4 ||
                    format == AttrImageFormat.C8 ||
                    format == AttrImageFormat.C14;
            }
        }
    }
    #endregion

    // rplt要素

    #region <palette>
    /// <summary>
    /// palette要素クラス。
    /// </summary>
    public class Elem_palette : Element
    {
        /// <summary>属性</summary>
        public AttrPaletteFormat	format = AttrPaletteFormat._Unknown;
        /// <summary>属性</summary>
        public int					color_size = 0;
        /// <summary>要素内容</summary>
        public ushort[]				contents;
    }
    #endregion

    // rcha要素

    #region <node_anim_info>
    /// <summary>
    /// node_anim_info要素クラス。
    /// </summary>
    public class Elem_node_anim_info : Element
    {
        /// <summary>属性</summary>
        public int					frame_size = 1;
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public int					tool_end_frame = 0;
        /// <summary>属性</summary>
        public float				magnify = 1.0f;
        /// <summary>属性</summary>
        public AttrScalingRule		scaling_rule = AttrScalingRule._Unknown;
        /// <summary>属性</summary>
        public int					tool_node_size = 1;
        /// <summary>属性</summary>
        public int					node_size = 1;
        /// <summary>属性</summary>
        public bool					bake_animation = false;
        /// <summary>属性</summary>
        public Attr_frame_precision	frame_precision = Attr_frame_precision._Unknown;
        /// <summary>属性</summary>
        public bool					loop = false;
        /// <summary>属性</summary>
        public float				tolerance_scale = 0.0f;
        /// <summary>属性</summary>
        public float				tolerance_rotate = 0.0f;
        /// <summary>属性</summary>
        public float				tolerance_translate = 0.0f;
    }
    #endregion

    #region <node_anim_array>
    /// <summary>
    /// node_anim_array要素クラス。
    /// </summary>
    public class Elem_node_anim_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	node_anim = new ArrayList();
    }
    #endregion

    #region <node_anim>
    /// <summary>
    /// node_anim要素クラス。
    /// </summary>
    public class Elem_node_anim : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public string		node_name = "";
        /// <summary>属性</summary>
        public int			parent = -1;
        /// <summary>属性</summary>
        public int			child = -1;
        /// <summary>属性</summary>
        public int			sibling_next = -1;
        /// <summary>属性</summary>
        public int			sibling_prev = -1;
        /// <summary>属性</summary>
        public bool			scale_compensate = false;
        /// <summary>属性</summary>
        public bool			display_matrix = false;
        /// <summary>属性</summary>
        public bool			envelope_matrix = false;
        /// <summary>属性</summary>
        public bool			compress_enable = false;
        /// <summary>子要素</summary>
        public ArrayList	node_anim_target = new ArrayList();
        // TODO: node_anim_targetは必ず９つというルールになったので配列にする？
    }
    #endregion

    #region <node_anim_target>
    /// <summary>
    /// node_anim_target要素クラス。
    /// </summary>
    public class Elem_node_anim_target : Element
    {
        /// <summary>属性</summary>
        public Attr_node_anim_target	target = Attr_node_anim_target._Unknown;
        /// <summary>子要素</summary>
        public AnimDataElement			anim = null; // anim_constant/anim_hermite
    }
    #endregion

    // rvia要素

    #region <visibility_anim_info>
    /// <summary>
    /// visibility_anim_info要素クラス。
    /// </summary>
    public class Elem_visibility_anim_info : Element
    {
        /// <summary>属性</summary>
        public int					frame_size = 1;
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public int					tool_end_frame = 0;
        /// <summary>属性</summary>
        public int					tool_node_size = 1;
        /// <summary>属性</summary>
        public int					node_size = 1;
        /// <summary>属性</summary>
        public bool					bake_animation = false;
        /// <summary>属性</summary>
        public Attr_frame_precision	frame_precision = Attr_frame_precision._Unknown;
        /// <summary>属性</summary>
        public bool					loop = false;
    }
    #endregion

    #region <visibility_anim_array>
    /// <summary>
    /// visibility_anim_array要素クラス。
    /// </summary>
    public class Elem_visibility_anim_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	visibility_anim = new ArrayList();
    }
    #endregion

    #region <visibility_anim>
    /// <summary>
    /// visibility_anim要素クラス。
    /// </summary>
    public class Elem_visibility_anim : Element
    {
        /// <summary>属性</summary>
        public int							index = 0;
        /// <summary>属性</summary>
        public string						node_name = "";
        /// <summary>属性</summary>
        public int							parent = -1;
        /// <summary>属性</summary>
        public int							child = -1;
        /// <summary>属性</summary>
        public int							sibling_next = -1;
        /// <summary>属性</summary>
        public int							sibling_prev = -1;
        /// <summary>属性</summary>
        public bool							display_matrix = false;
        /// <summary>属性</summary>
        public bool							envelope_matrix = false;
        /// <summary>属性</summary>
        public bool							compress_enable = false;
        /// <summary>子要素</summary>
        public Elem_visibility_anim_target	visibility_anim_target = new Elem_visibility_anim_target();
    }
    #endregion

    #region <visibility_anim_target>
    /// <summary>
    /// visibility_anim_target要素クラス。
    /// </summary>
    public class Elem_visibility_anim_target : Element
    {
        /// <summary>属性</summary>
        public Attr_visibility_anim_target	target = Attr_visibility_anim_target._Unknown;
        /// <summary>子要素</summary>
        public AnimDataElement				anim = null; // anim_constant/anim_step
    }
    #endregion

    // rcla要素

    #region <color_anim_info>
    /// <summary>
    /// color_anim_info要素クラス。
    /// </summary>
    public class Elem_color_anim_info : Element
    {
        /// <summary>属性</summary>
        public int					frame_size = 1;
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public int					tool_end_frame = 0;
        /// <summary>属性</summary>
        public bool					bake_animation = false;
        /// <summary>属性</summary>
        public Attr_frame_precision	frame_precision = Attr_frame_precision._Unknown;
        /// <summary>属性</summary>
        public bool					loop = false;
        /// <summary>属性</summary>
        public float				tolerance_color = 0.0f;
    }
    #endregion

    #region <color_anim_array>
    /// <summary>
    /// color_anim_array要素クラス。
    /// </summary>
    public class Elem_color_anim_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	color_anim = new ArrayList();
    }
    #endregion

    #region <color_anim>
    /// <summary>
    /// color_anim要素クラス。
    /// </summary>
    public class Elem_color_anim : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public string		material_name = "";
        /// <summary>子要素</summary>
        public ArrayList	color_anim_target = new ArrayList();
    }
    #endregion

    #region <color_anim_target>
    /// <summary>
    /// color_anim_target要素クラス。
    /// </summary>
    public class Elem_color_anim_target : Element
    {
        /// <summary>属性</summary>
        public Attr_color_anim_target	target = Attr_color_anim_target._Unknown;
        /// <summary>子要素</summary>
        public AnimDataElement			anim = null; // anim_constant/anim_hermite
    }
    #endregion

    // rtpa要素

    #region <tex_pattern_anim_info>
    /// <summary>
    /// tex_pattern_anim_info要素クラス。
    /// </summary>
    public class Elem_tex_pattern_anim_info : Element
    {
        /// <summary>属性</summary>
        public int					frame_size = 1;
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public int					tool_end_frame = 0;
        /// <summary>属性</summary>
        public bool					bake_animation = false;
        /// <summary>属性</summary>
        public Attr_frame_precision	frame_precision = Attr_frame_precision._Unknown;
        /// <summary>属性</summary>
        public bool					loop = false;
    }
    #endregion

    #region <image_name_array>
    /// <summary>
    /// image_name_array要素クラス。
    /// </summary>
    public class Elem_image_name_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	image_name = new ArrayList();
    }
    #endregion

    #region <image_name>
    /// <summary>
    /// image_name要素クラス。
    /// </summary>
    public class Elem_image_name : Element
    {
        /// <summary>属性</summary>
        public int		index = 0;
        /// <summary>属性</summary>
        public string	name = "";
    }
    #endregion

    #region <palette_name_array>
    /// <summary>
    /// palette_name_array要素クラス。
    /// </summary>
    public class Elem_palette_name_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	palette_name = new ArrayList();
    }
    #endregion

    #region <palette_name>
    /// <summary>
    /// palette_name要素クラス。
    /// </summary>
    public class Elem_palette_name : Element
    {
        /// <summary>属性</summary>
        public int		index = 0;
        /// <summary>属性</summary>
        public string	name = "";
    }
    #endregion

    #region <tex_pattern_anim_array>
    /// <summary>
    /// tex_pattern_anim_array要素クラス。
    /// </summary>
    public class Elem_tex_pattern_anim_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_pattern_anim = new ArrayList();
    }
    #endregion

    #region <tex_pattern_anim>
    /// <summary>
    /// tex_pattern_anim要素クラス。
    /// </summary>
    public class Elem_tex_pattern_anim : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public string		material_name = "";
        /// <summary>属性</summary>
        public int			tex_map_index = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_pattern_anim_target = new ArrayList();
    }
    #endregion

    #region <tex_pattern_anim_target>
    /// <summary>
    /// tex_pattern_anim_target要素クラス。
    /// </summary>
    public class Elem_tex_pattern_anim_target : Element
    {
        /// <summary>属性</summary>
        public Attr_tex_pattern_anim_target	target = Attr_tex_pattern_anim_target._Unknown;
        /// <summary>子要素</summary>
        public AnimDataElement				anim = null; // anim_constant/anim_step
    }
    #endregion

    // rtsa要素

    #region <tex_srt_anim_info>
    /// <summary>
    /// tex_srt_anim_info要素クラス。
    /// </summary>
    public class Elem_tex_srt_anim_info : Element
    {
        /// <summary>属性</summary>
        public int					frame_size = 1;
        /// <summary>属性</summary>
        public int					tool_start_frame = 0;
        /// <summary>属性</summary>
        public int					tool_end_frame = 0;
        /// <summary>属性</summary>
        public AttrTexMatrixMode	tex_matrix_mode = AttrTexMatrixMode._Unknown;
        /// <summary>属性</summary>
        public bool					bake_animation = false;
        /// <summary>属性</summary>
        public Attr_frame_precision	frame_precision = Attr_frame_precision._Unknown;
        /// <summary>属性</summary>
        public bool					loop = false;
        /// <summary>属性</summary>
        public float				tolerance_tex_scale = 0.0f;
        /// <summary>属性</summary>
        public float				tolerance_tex_rotate = 0.0f;
        /// <summary>属性</summary>
        public float				tolerance_tex_translate = 0.0f;
    }
    #endregion

    #region <tex_srt_anim_array>
    /// <summary>
    /// tex_srt_anim_array要素クラス。
    /// </summary>
    public class Elem_tex_srt_anim_array : Element
    {
        /// <summary>属性</summary>
        public int			size = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_srt_anim = new ArrayList();
    }
    #endregion

    #region <tex_srt_anim>
    /// <summary>
    /// tex_srt_anim要素クラス。
    /// </summary>
    public class Elem_tex_srt_anim : Element
    {
        /// <summary>属性</summary>
        public int			index = 0;
        /// <summary>属性</summary>
        public string		material_name = "";
        /// <summary>属性</summary>
        public int			tex_matrix_index = 0;
        /// <summary>子要素</summary>
        public ArrayList	tex_srt_anim_target = new ArrayList();
    }
    #endregion

    #region <tex_srt_anim_target>
    /// <summary>
    /// tex_srt_anim_target要素クラス。
    /// </summary>
    public class Elem_tex_srt_anim_target : Element
    {
        /// <summary>属性</summary>
        public Attr_tex_srt_anim_target	target = Attr_tex_srt_anim_target._Unknown;
        /// <summary>子要素</summary>
        public AnimDataElement			anim = null; // anim_constant/anim_hermite
    }
    #endregion
}


