﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using LECore.Structures;
    using LECore.Structures.Core;

    using LD = LECore.Structures;
    using SO = LECore.Structures.SerializableObject.Lyt;

    /// <summary>
    /// ユーティリティクラス
    /// </summary>
    internal class SerializableConverterUtil
    {
        static readonly string _VersionString   = "1.0.0";


        /// <summary>
        /// ダミーのバージョン情報文字列を取得します。
        /// </summary>
        public string VersionString
        {
            get{ return _VersionString;}
        }

        /// <summary>
        /// 改行コードを \n => \r\n に置換します。
        /// （XMLシリアライザが読み込み時に \r\n を \n に置換しているようです。
        /// その置換の復元に利用します）
        /// </summary>
        public static string ReplaceLineFeedCode( string str )
        {
            if (str == null)
            {
                return null;
            }

            string res = str.Replace( "\r\n", "\n" );
            res = res.Replace( "\n", "\r\n" );
            return res;
        }
    }

}
