﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    class RlwnConverter
    {
        #region ------------ Rlwn 書き出し
        /// <summary>
        /// FileFmt.AnimContent[] ---- Rlwn
        /// </summary>
        public static FileFmt.AnimContent[] SavePerCharTransCurveAnim(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<LEWindow, AnimWindowTarget>(
                tag,
                ParamaterKind.Animation_Window,
                srcPane,
                x => x.ILEWindow is LEWindow ? new[] { new AnimContentSource<LEWindow>(x.PaneName, (LEWindow)x.ILEWindow) } : Enumerable.Empty<AnimContentSource<LEWindow>>(),
                x => new [] {
                        new AnimTargetSource(x.FrameSizeAnmAttr.TopAnmAttr, AnimTargetType.WindowFrameTop),
                        new AnimTargetSource(x.FrameSizeAnmAttr.BottomAnmAttr, AnimTargetType.WindowFrameBottom),
                        new AnimTargetSource(x.FrameSizeAnmAttr.LeftAnmAttr, AnimTargetType.WindowFrameLeft),
                        new AnimTargetSource(x.FrameSizeAnmAttr.RightAnmAttr, AnimTargetType.WindowFrameRight)
                    }
                ).ToArray();
        }
        #endregion -------------- Rlwn


        #region ----------- Rlwn 読み込み

        //------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

        /// <summary>
        /// AnimTargetType に相応しい、アニメーションアトリビュートを取得します。
        /// TODO:
        /// アニメーションアトリビュートは名前で検索可能なので、
        /// 名前でアトリビュートを取得するように変更したい。
        /// セーブフォーマットにアトリビュート名を記述するようにしたい。
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        static AnmAttribute GetPerCharTransformTargetAnmAttribute_(AppData.Pane dstPane, FileFmt.AnimTargetType type)
        {
            if (dstPane.ILEWindow == null)
            {
                return null;
            }

            LEWindow wnd = (dstPane.ILEWindow as LEWindow);

            switch (type)
            {
                case FileFmt.AnimTargetType.WindowFrameTop: return wnd.FrameSizeAnmAttr.TopAnmAttr;
                case FileFmt.AnimTargetType.WindowFrameBottom: return wnd.FrameSizeAnmAttr.BottomAnmAttr;
                case FileFmt.AnimTargetType.WindowFrameLeft: return wnd.FrameSizeAnmAttr.LeftAnmAttr;
                case FileFmt.AnimTargetType.WindowFrameRight: return wnd.FrameSizeAnmAttr.RightAnmAttr;

                default: Debug.Assert(false); return null;
            }
        }

        /// <summary>
        /// シリアライズデータ => アプリケーションデータ
        /// </summary>
        static public void LoadRlwnToPane(object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane dstPane = dstObject as Pane;
            if (dstPane == null)
            {
                return;
            }

            if (dstPane.PaneName != srcAnimContent.name)
            {
                return;
            }

            foreach (FileFmt.AnimTarget srcAnimTraget in srcAnimContent.Items)
            {
                AnmAttribute dstAttr = GetPerCharTransformTargetAnmAttribute_(dstPane, srcAnimTraget.target);
                Debug.Assert(dstAttr != null);
                RlanHelper.SetHermiteKeyFrame_(dstAttr, srcAnimTraget, tag);
            }
        }
        #endregion --------- Rlwn
    }
}
