﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Xml.Serialization;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.SerializableObject.Lct;
    using AppData = Structures;

    /// <summary>
    /// Rlmcをインポートするクラスです。
    /// </summary>
    internal class ClctImporter : BaseSingleImporter
    {
        ClctConverter _converter = null;

        /// <summary>
        /// 出力ファイルの拡張子を取得します(短縮)。
        /// </summary>
        public override string[] GetFileExtensionShort()
        {
            return new string[] { AppConstants.ContorlFileExtNoDot };
        }

        /// <summary>
        /// 出力ファイルの拡張子を取得します(長い)。
        /// </summary>
        public override string[] GetFileExtensionLong()
        {
            return new string[] { AppConstants.ContorlFileDesc };
        }

        #region BaseSingleImporter abstract メンバ

        /// <summary>
        /// シリアル化可能オブジェクトの型
        /// </summary>
        /// <returns></returns>
        public override Type GetDeselializableObjType()
        {
            return typeof(Document);
        }

        /// <summary>
        /// シリアル化可能オブジェクトに変換します。
        /// </summary>
        public override void ImportFromDeserializable_(
            ISubScene targetScene, string inPath, object srcDeserializable, LEMsgReporter msgReporter)
        {
            // XML デシリアライズしたクラスから、ツール内部クラスに変換します。
            if (_converter == null)
            {
                _converter = new ClctConverter(msgReporter);
            }

            _converter.LoadClctToPane(Scene.Instance, srcDeserializable as Document, inPath);
        }
        #endregion BaseSingleImporter abstract メンバ
    }
}
