﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using MaterialTexMapCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.IMaterialTexMap>;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures.Core.Command;

    /// <summary>
    /// TexGenManipulator の概要の説明です。
    /// </summary>
    public class TexGenManipulator
    {
        // 操作対象
        private MaterialTexMap _target = null;
        private MaterialTexMapCommandFactory _materialTexMapCommandFactory;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TexGenManipulator()
        {
            _materialTexMapCommandFactory = new MaterialTexMapCommandFactory(
                delegate( IMaterialTexMap src ){return new MaterialTexMapMemento( src );} );
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetTextBox"></param>
        //public void BindTarget( ITexGen targetTexGen )
        public void BindTarget( IMaterialTexMap targetMatTexMap )
        {
            _target = targetMatTexMap as MaterialTexMap;
            Debug.Assert( _target != null );
        }

        private TexGen _TargetTexGen
        {
            get { return _target.ITexGen as TexGen; }
        }

        /// <summary>
        /// 座標生成方法。
        /// </summary>
        public LETexGenMethod Method
        {
            set
            {
                if (_TargetTexGen.Method != value)
                {
                    _materialTexMapCommandFactory.Modify( _target, delegate()
                    {
                        _TargetTexGen.Method = value;
                    } );
                }
            }
        }

        /// <summary>
        /// 投影スケール
        /// </summary>
        public FVec2 ProjectionScale
        {
            set
            {
                if (_TargetTexGen.ProjectionScale != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.ProjectionScale = value;
                    });
                }
            }
        }

        /// <summary>
        /// 投影オフセット
        /// </summary>
        public FVec2 ProjectionOffset
        {
            set
            {
                if (_TargetTexGen.ProjectionOffset != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.ProjectionOffset = value;
                    });
                }
            }
        }

        /// <summary>
        /// 投影回転
        /// </summary>
        public FVec3 ProjectionRotate
        {
            set
            {
                if (_TargetTexGen.ProjectionRotate != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.ProjectionRotate = value;
                    });
                }
            }
        }

        /// <summary>
        /// 投影画角
        /// </summary>
        public float ProjectionFovy
        {
            set
            {
                if (_TargetTexGen.ProjectionFovy != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.ProjectionFovy = value;
                    });
                }
            }
        }

        /// <summary>
        /// レイアウトサイズに一致するように自動スケールするか
        /// </summary>
        public bool IsFittingLayoutSizeEnabled
        {
            set
            {
                if (_TargetTexGen.IsFittingLayoutSizeEnabled != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.IsFittingLayoutSizeEnabled = value;
                    });
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public bool IsFittingPaneSizeEnabled
        {
            set
            {
                if (_TargetTexGen.IsFittingPaneSizeEnabled != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.IsFittingPaneSizeEnabled = value;
                    });
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public bool IsAdjustProjectionPaneSREnabled
        {
            set
            {
                if (_TargetTexGen.IsAdjustProjectionPaneSREnabled != value)
                {
                    _materialTexMapCommandFactory.Modify(_target, delegate()
                    {
                        _TargetTexGen.IsAdjustProjectionPaneSREnabled = value;
                    });
                }
            }
        }
    }
}
