﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;

namespace LECore.Structures
{
    /// <summary>
    /// レイアウト画面座標系
    /// </summary>
    public struct LEScreenCoordinate
    {
        // テレビ画面左上の座標位置
        FVec2         _origin;
        // テレビ画面上方を示す正規ベクトル
        FVec2         _vecUp;

        #region プロパティ
        /// <summary>
        /// レイアウト画面原点
        /// </summary>
        public FVec2 Origin
        {
            get{ return _origin;}
        }

        /// <summary>
        /// レイアウト画面上方向ベクトル
        /// </summary>
        public FVec2 VecUp
        {
            get{ return _vecUp;}
        }
        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LEScreenCoordinate( FVec2 origin, FVec2 vecUp )
        {
            _origin   = new FVec2( origin );
            _vecUp    = new FVec2( vecUp );
        }

        /// <summary>
        /// 設定
        /// </summary>
        public void Set( FVec2 origin, FVec2 vecUp )
        {
            _origin.Set( origin );
            _vecUp.Set( vecUp );
        }
    }

    /// <summary>
    /// アプリケーションの詳細な設定(コンフィグレーション)を管理するクラスです。
    /// シングルトンクラスです。
    ///
    /// 3D エディタの TheApp の提供するメソッドの一部も、本クラスに移動されています。
    /// </summary>
    public class AppConfig
    {


        // シングルトンインスタンス
        static AppConfig        _theInst = null;

        // 言語モード
        //private static LanguageMode        _languageMode = LanguageMode.Japanese;
        // ＧＵＩフォント
        private static Font                   _guiFont     = null;
        private static Font                   _guiFontBold = null;
        private static LEScreenCoordinate   _screenCoordinate;



        public AppConfig()
        {
            // フォントの初期化
            _guiFont     = new Font("Tahoma", 8.25F, FontStyle.Regular, GraphicsUnit.Point, 0);
            _guiFontBold = new Font(_guiFont, FontStyle.Bold);
            _screenCoordinate = new LEScreenCoordinate( new FVec2( -320.0f, 240.0f ), new FVec2( 0.0f, 1.0f ) );
        }

        static public AppConfig    Inst
        {
            get
            {
                if( _theInst == null )
                {
                    _theInst = new AppConfig();
                }
                return _theInst;
            }
        }


        #region --------- プロパティ
        /// <summary>
        /// ＧＵＩフォント。
        /// </summary>
        public Font GuiFont
        {
            get { return _guiFont; }
        }

        /// <summary>
        /// ＧＵＩフォント（太字）。
        /// </summary>
        public Font GuiFontBold
        {
            get { return _guiFontBold; }
        }

        /// <summary>
        /// レイアウト画面座標系情報
        /// </summary>
        public LEScreenCoordinate ScreenCoordinate
        {
            get { return _screenCoordinate;}
        }

        #endregion // --------- プロパティ
    }
}
