﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections;
using namespace System::Collections::Generic;

#include "NW4RFont.h"

#ifdef NW_LAYOUTEDITOR_CAFE

#include "scfont_TextureCache.h"
#include "scfont_ScalableFont.h"

namespace NW4R
{
namespace Font
{
    //
    // リソースから初期化される、フォントクラス
    // UnManaged::ResFont クラスのマネージド・ラッパー
    //
    public ref class ScFont : public INWFont
    {

    private:

        nw::scfont::TextureCache* m_TextureCache;
        nw::scfont::ScalableFont* m_pFont;

        array<INWFont::SheetPropaties^>^     m_pSheetPropSet;
        array<IntPtr>^ m_NativeFontResources;
        List<IntPtr>^ m_FontDatas;

        void CopyTo32bitBmp_(const void* pSrc, INWFont::SheetPropaties^ pDstSheet, UnManaged::TextureSize size );

    protected:
        enum class AlternateChar {
            CHARCODE_ALTERNATE_WHITESPACE = 0x3000
        };

        enum class AlternateCharMode {
            USE_WHITESPACE,
            USE_WHITESPACE_FOR_NOT_READY_CHAR,
            USE_ALTERNATE_CHAR
        };

    public:

        ref struct InitializeArg
        {
            //nw::scfont::TextureCache* textureCache;

            int fontSize;
            u16 fontFace;
            bool isAlternateCharSpaceWithOriginalWidth;
            bool isAlternateCharSpaceWithOriginalWidthForNotReadyChar;
            uint alternateChar;
            int lineFeedOffset;

            array<array<IntPtr>^>^ fontDatas;

            array<array<int>^>^ fontDataSizes;
            array<array<int>^>^ fontTypes;
            array<array<float>^>^ fontBoldWeights;
            array<array<int>^>^ fontBorderSizes;
            array<array<float>^>^ fontScaleWidths;
            array<array<float>^>^ fontScaleHeights;
            array<array<bool>^>^ ignorePalt;
            array<array<bool>^>^ deleteBearingX;
            array<array<int>^>^ bearingOffsetX;
            array<array<bool>^>^ forceMonospacedEnabled;
            array<array<int>^>^ forceMonospacedWidth;
            array<array<int>^>^ baselineOffset;
            array<array<int>^>^ charCodeRangeCount;
            array<array<array<u32>^>^>^ charCodeRangeFirst;
            array<array<array<u32>^>^>^ charCodeRangeLast;

            u32 textureCacheWidth;
            u32 textureCacheHeight;

            InitializeArg();
        };

        // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
        virtual array<INWFont::SheetPropaties^>^  GetSheetPropaties() override ;

        // アンマネージドフォントを取得します。
        // NW4RTextWriter から利用されます。
        virtual UnManaged::Font* GetUnManagedFont() override ;


        // コンストラクタ
        ScFont();
        ~ScFont();

        void UpdateAndCompleteTheTextureCache();

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResource( array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater ) override ;
        virtual bool SetResources( array<array<Byte>^>^  byteArrays, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater ) override ;

        // リソース解除
        virtual void RemoveResource() override ;

        void Initialize(InitializeArg^ arg);

        bool RegisterGlyph(u16 code){return RegisterGlyph(code, -1);}
        bool RegisterGlyph(u16 code, s32 lockGroup);
        u32 RegisterGlyphs(const u16* codes, s32 lockGroup);
        u32 RegisterGlyphsWithLength(const u16* codes, u32 codeLength, s32 lockGroup);
        void ResetTextureCache();

        void ClearLockGlyphs(const u16* codes, s32 lockGroup);
        void ClearLockGlyphsWithLength(const u16* codes, u32 codeLength, s32 lockGroup);

        void RegisterAlternateCharGlyph();

        u16 GetFontFace();

        bool IsDrawMultiCore();
        bool IsGlyphPlot(u16 code);
        bool IsGlyphExistInFont(u16 code);

        void SetGlyphUsed(u16 code);

        void SetHeight(int height);
        void SetBaselinePos(int pos);

        // ベースライン位置を取得します。
        int GetBaselinePos();

        // ピクセル単位でのセルの高さを返します。
        // バイナリファイル中に含まれる、グリフを元に算出される大きさです。
        // フィルタの影響を受けます。
        int GetCellHeight();

        // ピクセル単位でのセルの幅を返します。
        int GetCellWidth();

        // ピクセル単位でのフォントの高さを返します。
        virtual int GetHeight() override ;

        // ピクセル単位でのセルの幅を返します。
        virtual int GetWidth() override ;

        // フォントに含まれる最大の文字幅をピクセル単位で返します。
        // ソースデータ全体から算出される値のため、フィルタの影響を受けません。
        // = GetWidth()
        int GetMaxCharWidth();

        // フォントがもつ改行幅を設定します。
        // フォントの改行幅は TextWriter が 1 行の高さの基準として用いる値です。
        // この値はフォントの高さやセルの高さとは無関係です
        // （大小関係が定められていません）が、
        // fontcvtr はデフォルトではフォントの高さをフォントの改行幅として設定します。
        void SetLineFeed( int linefeed );

        // 初回描画時の初期化を行います。
        virtual void InitializeAtTheFirstTimeDraw() override ;

        // 1行の高さを返します。
        int GetLineFeed();

        // エンコーディングの種類を返します。
        virtual INWFont::FontEncoding   GetEncoding() override ;

        // カーニング情報を持つか取得します。
        virtual bool HasKerning() override ;

        // パック形式か取得します。
        virtual bool IsPackedFormatFont() override { return false; };

        // 特殊フチ形式が設定可能かを取得します。
        virtual bool IsAvailableBorder() override { return true; }

        // 縁付かきどうか取得します
        virtual bool IsBorderEffectEnabled() override;

        // SRGB フェッチが必要なフォーマットか取得します。
        virtual bool IsNeededToSrgbFetch() override { return false; }

        // 描画準備完了か？
        virtual bool IsReadyToDraw() override ;
    };
}
}

#else // NW_LAYOUTEDITOR_CAFE

namespace nw{ namespace scfont{
    class TextureCache
    {
        // ダミークラス
    };
}}

namespace NW4R
{
namespace Font
{
    // ダミーの実装です。
    public ref class ScFont : public INWFont
    {
    public:
        ref struct InitializeArg
        {
            nw::scfont::TextureCache* textureCache;

            int fontSize;
            u16 fontFace;
            bool isAlternateCharSpaceWithOriginalWidth;
            bool isAlternateCharSpaceWithOriginalWidthForNotReadyChar;

            array<IntPtr>^ fontDatas;
            array<int>^ fontDataSizes;
            array<int>^ fontTypes;
            array<float>^ fontBoldWeights;
            array<int>^ fontBorderSizes;
        };

        // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
        virtual array<INWFont::SheetPropaties^>^  GetSheetPropaties() override
        {
            return nullptr;
        }

        // アンマネージドフォントを取得します。
        // NW4RTextWriter から利用されます。
        virtual UnManaged::Font* GetUnManagedFont() override
        {
            return NULL;
        }

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResource(array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater) override
        {
            return false;
        }

        // リソース解除
        virtual void RemoveResource() override {}

        // 初回描画時の初期化を行います。
        virtual void InitializeAtTheFirstTimeDraw() override {}

        // ピクセル単位でのフォントの高さを返します。
        virtual int GetHeight() override { return 0; }

        // ピクセル単位でのセルの幅を返します。
        virtual int GetWidth() override { return 0; }

        // エンコーディングの種類を返します。
        virtual FontEncoding   GetEncoding() override { return INWFont::FontEncoding::FONT_ENCODING_UTF16; }

        // カーニング情報を持つか取得します。
        virtual bool HasKerning() override { return false; }

        // パック形式か取得します。
        virtual bool IsPackedFormatFont() override { return false; }

        // SRGB フェッチが必要なフォーマットか取得します。
        virtual bool IsNeededToSrgbFetch() override { return false; }

        // 描画準備完了か？
        virtual bool IsReadyToDraw() override { return false; }
        bool IsGlyphPlot(u16 code){return false;}
        bool IsGlyphExistInFont(u16 code) {return false;}
        bool RegisterGlyph(u16 code, s32 lockGroup){return false;}


        void UpdateAndCompleteTheTextureCache(){}

        void SetGlyphUsed(u16 code){}

        void ResetTextureCache(){}
        void RegisterAlternateCharGlyph(){}
    };
}
}
#endif // NW_LAYOUTEDITOR_CAFE
