﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections;

#include "ResFont.h"

namespace NW4R
{
namespace Font
{
    public ref class ITextureConvertUtility abstract
    {
    public:
        virtual System::UInt32 GetFontResourceVersion() = 0;
        virtual void SetPlatform(System::IntPtr platformName, System::IntPtr toolsPath) = 0;
        virtual bool InitializeOpenGL(System::IntPtr deviceContext) = 0;
        virtual bool FinalizeOpenGL() = 0;
        virtual System::IntPtr BuildNewTextureRGBAImage(System::IntPtr pFontInfo, System::IntPtr pPtrOffsetBase) = 0;

        // SRGBフェッチを必要とするフォーマットかどうかを取得します。非 SRGB フォーマットテクスチャで有効(true)になります。
        virtual bool IsNeededToSrgbFetchFormat(System::IntPtr pFontTextureGlyph) = 0;
        virtual bool IsNeededToSrgbFetchFormat(u16 sheetFormat) = 0;
        virtual bool IsFontResourceBigEndian() = 0;
        virtual System::String^ GetPlatform(System::IntPtr pFontInfo, System::IntPtr pPtrOffsetBase) = 0;
    };

    public ref class INWFont abstract
    {
    public:
        //
        // 各グリフが参照するフォントイメージを表すテクスチャデータに関する
        // パラメータ群です。GetSheetPropaties()の返り値を格納するクラスとして用意されています。
        //
        ref class SheetPropaties
        {
        public:
            int             texWidth;
            int             texHeight;
            IntPtr          imgPtr;
        };

        enum class FontEncoding
        {
            FONT_ENCODING_UTF8,         // UTF-8
            FONT_ENCODING_UTF16,        // UTF-16
            FONT_ENCODING_SJIS,         // ShiftJIS
            FONT_ENCODING_CP1252,       // CP1252
            NUM_OF_FONT_ENCODING
        };

        enum class TargetPlatform
        {
            CTR,         // CTR
            CAFE,        // CAFE
            Max
        };

        // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
        virtual array<INWFont::SheetPropaties^>^  GetSheetPropaties() = 0;

        // アンマネージドフォントを取得します。
        // NW4RTextWriter から利用されます。
        virtual UnManaged::Font* GetUnManagedFont() = 0;

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResource( array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater) = 0;

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResources( array<array<Byte>^>^  byteArrays, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater) = 0;

        // リソース解除
        virtual void RemoveResource() = 0;

        // 初回描画時の初期化を行います。
        virtual void InitializeAtTheFirstTimeDraw() = 0;

        // ピクセル単位でのフォントの高さを返します。
        virtual int GetHeight() = 0;

        // ピクセル単位でのセルの幅を返します。
        virtual int GetWidth() = 0;

        // エンコーディングの種類を返します。
        virtual FontEncoding   GetEncoding() = 0;

        // カーニング情報を持つか取得します。
        virtual bool HasKerning() = 0;

        // パック形式か取得します。
        virtual bool IsPackedFormatFont() = 0;

        // 特殊フチ形式が設定可能かを取得します。
        virtual bool IsAvailableBorder() = 0;

        // SRGB フェッチが必要なフォーマットか取得します。
        virtual bool IsNeededToSrgbFetch() = 0;

        // 縁付きかどうか取得します
        virtual bool IsBorderEffectEnabled() = 0;

        // 描画準備完了か？
        virtual bool IsReadyToDraw() = 0;
    };

    public interface class IGetPlatform
    {
        virtual System::String^ GetPlatform();
    };

    //
    // リソースから初期化される、フォントクラス
    // UnManaged::ResFont クラスのマネージド・ラッパー
    //
    public ref class NW4RResFont : public INWFont, IGetPlatform
    {
    private:

        //
        // アンマネージフォントへのポインタ
        //
        UnManaged::detail::ResFontBase*          m_pResFont;
        //
        // リソースデータのアンマネージド側でのコピー。
        // GC によるメモリの移動の影響を受けないために、必ず必要となります。
        //
        IntPtr                       m_intPtrToResourceDataCopy;

        // アーカイブフォント用バッファ
        // 32バイトアラインされます。
        // Construct関数内で、確保され、
        // 本クラスのデストラクタで開放されます。
        IntPtr                       m_pArchiveFontBuffer;

        array<INWFont::SheetPropaties^>^     m_pSheetPropSet;

        // プラットフォーム固有の処理
        ITextureConvertUtility^ mPlatformUtility;

    public:

        //
        // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
        //
        //
        virtual array<SheetPropaties^>^  GetSheetPropaties() override ;

        // アンマネージドフォントを取得します。
        // NW4RTextWriter から利用されます。
        virtual UnManaged::Font* GetUnManagedFont() override ;

        // コンストラクタ
        NW4RResFont();
        ~NW4RResFont();

        // ファイルロード結果バイト配列から、データを設定します。
       virtual bool SetResource( array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater ) override ;
       virtual bool SetResources( array<array<Byte>^>^  byteArrays, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater ) override ;

        // リソース解除
       virtual void RemoveResource() override ;

       // ピクセル単位でのフォントの高さを返します。
       virtual int GetHeight() override ;

       // ピクセル単位でのセルの幅を返します。
       virtual int GetWidth() override ;

       // 初回描画時の初期化を行います。
       virtual void InitializeAtTheFirstTimeDraw() override ;

       // エンコーディングの種類を返します。
       virtual INWFont::FontEncoding   GetEncoding() override ;

       // カーニング情報を持つか取得します。
       virtual bool HasKerning() override ;

       // パック形式か取得します。
       virtual bool IsPackedFormatFont() override ;

       // 特殊フチ形式が設定可能かを取得します。
       virtual bool IsAvailableBorder() override;

       // 縁付きかどうか取得します
       virtual bool IsBorderEffectEnabled() override { return false;}

       // SRGB フェッチが必要なフォーマットか取得します。
       virtual bool IsNeededToSrgbFetch() override ;

       // 描画準備完了か？
       virtual bool IsReadyToDraw() override ;

       static int ValidateBinary(array<Byte>^ byteArray, System::UInt32 correctResourceVersion);

       virtual System::String^ GetPlatform();

       // TODO: Pair 以下のフォント専用のものを整理したい

       // Pair フォント以下のフォントのフィルタフォント作成用
       System::String^ SourcePath;

       // 使用文字コード範囲のセットを設定します。
       void SetCharCodeRange(array<u32>^ first, array<u32>^ last);
    };
}
}
