﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/

#pragma once


#include "Font.h"
namespace nn
{
namespace font
{
namespace font = NW4R::Font::UnManaged;

class PairFont : public font::Font
{
public:

    //! @name コンストラクタ / デストラクタ
    //@{

    //! @brief      コンストラクタです。
    //!
    PairFont();

    //! @brief      コンストラクタです。
    //!
    //! @details
    //! 2つのフォントは文字コードが
    //! 同じでなければなりません。
    //!
    //! @param[in]  primary    フォントへのポインタ。
    //! @param[in]  secondary  フォントへのポインタ。
    //!
    PairFont(
        Font*   primary,
        Font*   secondary);

    //! デストラクタです。
    virtual                     ~PairFont();

    //@}


    //! @name フォントの設定・取得
    //@{

    //! @brief      フォントを設定します。
    //!
    //! @details
    //! 2つのフォントは文字コードが
    //! 同じでなければなりません。
    //!
    //! @param[in]  primary    フォントへのポインタ。
    //! @param[in]  secondary  フォントへのポインタ。
    //!
    void                        SetFont(Font* primary, Font* secondary);

    //---- フォント全体情報アクセサ
    // ピクセル単位でのセルの幅を返します。
    virtual int                 GetWidth() const;
    virtual int                 GetHeight() const;
    virtual int                 GetAscent() const;
    virtual int                 GetDescent() const;
    virtual int                 GetBaselinePos() const;
    virtual int                 GetCellHeight() const;
    virtual int                 GetCellWidth() const;
    virtual int                 GetMaxCharWidth() const;
    virtual Type                GetType() const;
    virtual GXTexFmt            GetTextureFormat() const;
    virtual int                 GetLineFeed() const;
    virtual const font::CharWidths    GetDefaultCharWidths() const;

    virtual void                SetDefaultCharWidths(
        const font::CharWidths& widths        // 新しいデフォルト幅
    );

    virtual bool                SetAlternateChar(font::CharCode c); // 新しい代替文字
    virtual void                SetLineFeed(int linefeed);    // 新しい改行幅

                                                                  //---- 文字単体情報アクセサ
    virtual int                 GetCharWidth(
        font::CharCode c) const;         // 幅を求める文字
    virtual const font::CharWidths    GetCharWidths(
        font::CharCode c) const;         // 幅を求める文字
    virtual void                GetGlyph(
        font::Glyph*      glyphPtr,           // グリフ情報を受け取るバッファ
        font::CharCode    c                   // グリフ情報を取得する文字
    ) const;
    virtual bool                HasGlyph(font::CharCode c) const;     // グリフ情報があるか
    virtual int            GetKerning(font::CharCode c0, font::CharCode c1) const; // カーニングの値を取得します。
    virtual bool           HasKerning() const; // カーニングの値を持っているか？
    virtual font::FontType       GetFontType() const;
    virtual font::FontEncoding   GetEncoding() const;

    // 追加：.NET モジュールでテクスチャの検索を行う際に利用します。
    virtual int           GetSheetNum() const;

    // 追加
    // 判定は末端の要素に任せるので実はどちらでもよい
    virtual bool          IsBitmapFont() { return false; }

private:
    /* ------------------------------------------------------------------------
    変数
    ------------------------------------------------------------------------ */
    // フォントの実体へのポインタ
    Font*                       m_First;
    Font*                       m_Second;
    // 代替文字を1つ目のフォントから取得するかどうか
    bool                        m_AlternateWithPrimary;
};
}
}
