﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_ROMFONT_H_
#define NW4R_UT_ROMFONT_H_

#include <dolphin/types.h>
#include "Font.h"

namespace nw4r {
    namespace ut {



class RomFont
    : public Font
{
public:
    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ/デストラクタ
                                RomFont();
    virtual                     ~RomFont();

    //---- 構築
    bool                        Load(void* buffer);
    void*                       Unload();
    static u32                  GetRequireBufferSize();

    //---- フォント全体情報アクセサ
    virtual int                 GetBaselinePos() const;
    virtual int                 GetCellHeight() const;
    virtual int                 GetCellWidth() const;
    virtual int                 GetHeight() const;
    virtual int                 GetMaxCharWidth() const;
    virtual Type                GetType() const;
    virtual GXTexFmt            GetTextureFormat() const;
    virtual int                 GetLineFeed() const;
    virtual const CharWidths    GetDefaultCharWidths() const;

    virtual void                SetDefaultCharWidths(
                                    const CharWidths& widths        // 新しいデフォルト幅
                                );

    virtual bool                SetAlternateChar(
                                    CharCode c );                   // 新しい代替文字

    virtual void                SetLineFeed(
                                    int linefeed );                 // 新しい改行幅

    //---- 文字単体情報アクセサ
    virtual int                 GetCharWidth(
                                    CharCode c                      // 幅を求める文字
                                ) const;

    virtual const CharWidths    GetCharWidths(
                                    CharCode c                      // 幅を求める文字
                                ) const;

    virtual void                GetGlyph(
                                    Glyph*      glyphPtr,           // グリフ情報を受け取るバッファ
                                    CharCode    c                   // グリフ情報を取得する文字
                                ) const;

    //---- 文字ストリーム処理
    virtual FontEncoding        GetEncoding() const;



private:
    /* ------------------------------------------------------------------------
            定数
       ------------------------------------------------------------------------ */
    const static int            CHAR_PTR_BUFFER_SIZE = 3;


    /* ------------------------------------------------------------------------
            変数
       ------------------------------------------------------------------------ */
    static u16                  mFontEncode;                    // フォントエンコーディング
    OSFontHeader*               mFontHeader;                    // フォントデータヘッダへのポインタ
    CharWidths                  mDefaultWidths;                 // デフォルト幅
    CharCode                    mAlternateChar;                 // 代替文字の文字コード


    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- OS関数用文字文字列化
    void                        MakeCharPtr(
                                    char*       buffer,             // ポインタ化する文字
                                    CharCode   c                    // 対象の文字
                                ) const;

    CharCode                    HandleUndefinedChar(
                                    CharCode c                      // 対象の文字
                                ) const;
};





    } /* namespace ut */
} /* namespace nw4r */
#endif //  NW4R_UT_ROMFONT_H_
