﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_ARCHIVEFONT_H_
#define NW4R_UT_ARCHIVEFONT_H_

#include <dolphin/types.h>
#include "ArchiveFontBase.h"


namespace NW4R
{
namespace Font
{
namespace UnManaged
{


class ArchiveFont
    : public detail::ArchiveFontBase
{
public:
    /* ------------------------------------------------------------------------
            定数
       ------------------------------------------------------------------------ */
    static const int HEADER_SIZE = 16 * 1024;


    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ/デストラクタ
                    ArchiveFont();
    virtual         ~ArchiveFont();

    //---- 構築/破棄
    bool            Construct(
                        void*               pBuffer,                    //
                        u32                 bufferSize,                 //
                        const void*         brfnt,                      //
                        const char*         glyphGroups=LOAD_GLYPH_ALL  //
                    );

    void            InitStreamingConstruct(
                        ConstructContext*   pContext,                   //
                        void*               pBuffer,                    //
                        u32                 bufferSize,                 //
                        const char*         glyphGroups=LOAD_GLYPH_ALL  //
                    );

    ConstructResult StreamingConstruct(
                        ConstructContext*   pContext,                   //
                        const void*         stream,                     //
                        u32                 streamSize                  //
                    );

    void*           Destroy();


    static void     UnpackData(
                        const void* brfnt
                    );

    static u32      GetRequireBufferSize(
                        const void*         brfnt,                      //
                        const char*         glyphGroups=LOAD_GLYPH_ALL  //
                    );


    //---- ResFontBase のオーバーライド
    virtual void    GetGlyph(
                        Glyph*      glyph,              // グリフ情報を受け取るバッファ
                        CharCode    c                   // グリフ情報を取得する文字
                    ) const;

private:
    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- グリフインデックス
    void            GetGlyphFromIndex(
                        Glyph*      glyph,              // グリフ情報を受け取るバッファ
                        GlyphIndex  index               // 対象のグリフインデックス
                    ) const;
};




    } /* UnManaged */
    } /* namespace ut */
} /* namespace nw4r */
#endif //  NW4R_UT_ARCHIVEFONT_H_
