﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;

    [Serializable]
    public class ConvertSettings
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ConvertSettings()
        {
            this.InputMode = 2;
            this.InImageSettings = new InImageSettings();
            this.InRuntimeBinarySettings = new InRuntimeBinarySettings();
            this.InWinSettings = new InWinSettings();
            this.OutImageSettings = new OutImageSettings();
            this.OutRuntimeBinarySettings = new OutRuntimeBinarySettings();
        }

        public int InputMode { get; set; }
        public int OutputMode { get; set; }
        public bool UseFilter { get; set; }
        public StringList FilePaths { get; set; }

        public InImageSettings InImageSettings { get; set; }
        public InRuntimeBinarySettings InRuntimeBinarySettings { get; set; }
        public InWinSettings InWinSettings { get; set; }
        public OutImageSettings OutImageSettings { get; set; }
        public OutRuntimeBinarySettings OutRuntimeBinarySettings { get; set; }
    }
}
