﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Windows.Media;

    public enum ImageFileFormat
    {
        Ext,
        Bmp,
        Tga,
        Tif,

        NUM
    }

    public class FB
    {
        // 各パーツの大きさ
        public const int BorderWidth = 1;
        public const int PaddingWidth = 1;
        public const int BarWidth = 1;

        // 上下左右の枠領域
        public const int NoCellAreaTop = BorderWidth + PaddingWidth;
        public const int NoCellAreaBottom = PaddingWidth + BarWidth + PaddingWidth + BorderWidth;
        public const int NoCellAreaLeft = BorderWidth + PaddingWidth;
        public const int NoCellAreaRight = PaddingWidth + BorderWidth;

        // 上下/左右の枠領域合計
        public const int NoCellAreaH = NoCellAreaLeft + NoCellAreaRight;
        public const int NoCellAreaV = NoCellAreaTop + NoCellAreaBottom;

        // デフォルトカラー
        public static readonly Color BackgroundColor = Color.FromRgb(255, 255, 255);
        public static readonly Color GridColor = Color.FromRgb(0, 0, 0);
        public static readonly Color MarginColor = Color.FromRgb(153, 170, 153);
        public static readonly Color WidthBarColor = Color.FromRgb(255, 0, 0);
        public static readonly Color NullBlockColor = Color.FromRgb(255, 127, 127);
    }
}
