﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics;
    using System.IO;
    using NintendoWare.Font.Runtime;

    public class NnsReader
    {
        private readonly ByteOrderBinaryReader br;

        public NnsReader(Stream stream)
        {
            this.br = new ByteOrderBinaryReader(stream, ConverterEnvironment.IsInputTargetLittleEndian);
        }

        // ヘッダへのポインタをメンバに格納し最初のバイナリブロックへのポインタを返す
        public int ReadHeader(NnsData nnsData)
        {
            BinaryFileHeader header;

            this.br.Read(out header);

            nnsData.SetHeader(header);

            return header.HeaderSize;
        }

        // バイナリブロックをmapに登録し次のバイナリブロックへのポインタを返す
        public void ReadBlock(NnsData nnsData, Func<Signature32, IBinarizable> factory)
        {
            var blockOffset = this.br.BaseStream.Position;
            BinaryBlockHeader block;
            this.br.Read(out block);

            var contentsSize = (int)block.Size - Runtime.BinaryBlockHeader.Length;
            var binObj = factory(block.Kind);
            if (binObj != null)
            {
                binObj.Read(this.br, contentsSize);
                Debug.Assert(GlCm.ROUND_UP((int)this.br.BaseStream.Position, 4) == blockOffset + block.Size);
                nnsData.SetBlock(block.Kind, binObj);
            }

            this.br.Seek((int)(blockOffset + block.Size), SeekOrigin.Begin);
        }
    }
}
