﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics;

    public class IndexImage : ImageBase
    {
        private IntColor[] colorTable;
        private int tableEntry;

        public IndexImage()
        {
            this.tableEntry = 0;
        }

        public override bool IsIndexed { get { return true; } }

        public override ImageBase NewSameType()
        {
            return new IndexImage();
        }

        public void SetGrayScaleTable(int bpp)
        {
            Debug.Assert(Bpp >= 0);
            if (bpp == 0)
            {
                bpp = Bpp;
            }

            int colorNum = 1 << bpp;
            var plt = new IntColor[colorNum];

            for (int i = 0; i < colorNum; i++)
            {
                byte level = (byte)((colorNum - i - 1) * 255 / (colorNum - 1));
                plt[i] = GlCm.BMP_RGB(level, level, level);
            }

            this.SetColorTable(plt, colorNum);
        }

        public void SetColorTable(IntColor[] table, int num)
        {
            Array.Resize(ref this.colorTable, num);
            Array.Copy(table, this.colorTable, num);
            this.tableEntry = num;
        }

        public IntColor[] GetColorTable()
        {
            return this.colorTable;
        }

        public int GetColorTableEntryNum()
        {
            return this.tableEntry;
        }

        public override uint GetRGB(int x, int y)
        {
            uint idx = GetColor(x, y);
            Debug.Assert((int)idx < this.tableEntry);
            return this.colorTable[idx];
        }

        public override void Extract(ImageBase image, int x, int y, int width, int height)
        {
            base.Extract(image, x, y, width, height);
            ((IndexImage)image).SetColorTable(this.GetColorTable(), this.GetColorTableEntryNum());
        }
    }
}
