﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// フォントの階調数のViewModelです。
    /// </summary>
    public class BppViewModel
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="bpp">階調数。</param>
        /// <param name="hasAlpha">アルファを持つ場合は真。</param>
        /// <param name="displayName">表示名。</param>
        /// <param name="typeName">型をあらわす文字列。</param>
        public BppViewModel(int bpp, bool hasAlpha, string displayName, string typeName)
        {
            this.Bpp = bpp;
            this.HasAlpha = hasAlpha;
            this.DisplayName = displayName;
            this.TypeName = typeName;
        }

        /// <summary>
        /// 階調数を取得します。
        /// </summary>
        public int Bpp { get; private set; }

        /// <summary>
        /// アルファを持つかどうかを判別する値を取得します。
        /// </summary>
        public bool HasAlpha { get; private set; }

        /// <summary>
        /// 表示名を取得します。
        /// </summary>
        public string DisplayName { get; private set; }

        /// <summary>
        /// 階調数が2ビットかどうかを判別する値を取得します。
        /// </summary>
        public bool Is2Bit
        {
            get { return this.Bpp == 1; }
        }

        /// <summary>
        /// 型名を取得します。
        /// </summary>
        public string TypeName { get; private set; }
    }
}
