﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nns/gfx/gfx_PrimitiveRenderer.h>
#include <nn/vfx.h>

//------------------------------------------------------------------------------
// エミッタのGPU処理を計測する為のコールバック関数
//------------------------------------------------------------------------------
void DrawEmitterProfileCallback( nn::vfx::DrawEmitterProfilerArg& arg ) NN_NOEXCEPT;

//------------------------------------------------------------------------------
// vfx システム 詳細情報を表示します。
//------------------------------------------------------------------------------
void DrawSystemInfo( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::vfx::System* pVfxSystem, float x, float y, size_t dynamicHeapSize ) NN_NOEXCEPT;

//------------------------------------------------------------------------------
// エミッタセット詳細情報を表示します。
//------------------------------------------------------------------------------
void DrawEmitterSetInfo( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::vfx::System* pVfxSystem, float x, float y, int groupID ) NN_NOEXCEPT;

//------------------------------------------------------------------------------
// vfx ビューア 詳細情報を表示します。
//------------------------------------------------------------------------------
void DrawViewerInfo( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::util::DebugFontTextWriter* pTextWriter, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer, nn::vfx::System* pVfxSystem, float x, float y, size_t dynamicHeapSize, float viewerCounter, float viewerCounterMax ) NN_NOEXCEPT;

