﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System;
    using System.Drawing;
    using System.Runtime.InteropServices;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb tree view.
    /// </summary>
    public class EBTreeView : TreeView
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBTreeView"/> class.
        /// </summary>
        public EBTreeView()
        {
            this.DrawMode = TreeViewDrawMode.OwnerDrawText;
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// The on draw node.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnDrawNode(DrawTreeNodeEventArgs e)
        {
            base.OnDrawNode(e);

            var foreColor = e.Node.ForeColor;
            {
                if (foreColor == Color.Empty)
                {
                    foreColor = e.Node.TreeView.ForeColor;
                }

                if (e.Node == e.Node.TreeView.SelectedNode)
                {
                    foreColor = this.Focused ? SystemColors.HighlightText : SystemColors.ControlText;
                }
            }

            using (var brush = new SolidBrush(e.Node.BackColor))
            {
                var font = e.Node.NodeFont ?? e.Node.TreeView.Font;
                var size = TextRenderer.MeasureText(e.Node.Text, font);
                var rect = new Rectangle(e.Bounds.X - 1, e.Bounds.Y, size.Width + 2, e.Bounds.Height);

                e.Graphics.FillRectangle(brush, rect);
                TextRenderer.DrawText(
                    e.Graphics,
                    e.Node.Text,
                    font,
                    rect,
                    foreColor,
                    TextFormatFlags.GlyphOverhangPadding);
            }
        }

        /// <summary>
        /// The on handle created.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnHandleCreated(EventArgs e)
        {
            base.OnHandleCreated(e);

            const int TvmSetextendedstyle = 0x1100 + 44;
            const int TvsExDoublebuffer = 0x0004;

            // チラツキを抑える
            SendMessage(this.Handle, TvmSetextendedstyle, new IntPtr(TvsExDoublebuffer), new IntPtr(TvsExDoublebuffer));
        }

        /// <summary>
        /// The send message.
        /// </summary>
        /// <param name="handle">
        /// The handle.
        /// </param>
        /// <param name="msg">
        /// The msg.
        /// </param>
        /// <param name="wparam">
        /// The w param.
        /// </param>
        /// <param name="lparam">
        /// The l param.
        /// </param>
        /// <returns>
        /// The <see cref="IntPtr"/>.
        /// </returns>
        [DllImport("user32.dll")]
        private static extern IntPtr SendMessage(IntPtr handle, int msg, IntPtr wparam, IntPtr lparam);

        #endregion
    }
}
