﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System.Drawing;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb tool strip.
    /// </summary>
    public class EBToolStrip : ToolStrip
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBToolStrip"/> class.
        /// コンストラクタ
        /// </summary>
        public EBToolStrip()
        {
            this.DoubleBuffered = true;

            this.Renderer = new ToolStripProfessionalRenderer(new CustomProfessionalRenderer());
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether double buffered.
        /// </summary>
        protected override sealed bool DoubleBuffered
        {
            get
            {
                return base.DoubleBuffered;
            }

            set
            {
                base.DoubleBuffered = value;
            }
        }

        #endregion

        /// <summary>
        /// The custom professional renderer.
        /// </summary>
        public class CustomProfessionalRenderer : ProfessionalColorTable
        {
            // ToolStripのグラデーションの色を指定
            #region Public Properties

            /// <summary>
            /// Gets the tool strip gradient begin.
            /// </summary>
            public override Color ToolStripGradientBegin
            {
                get
                {
                    return SystemColors.Control;
                }
            }

            /// <summary>
            /// Gets the tool strip gradient end.
            /// </summary>
            public override Color ToolStripGradientEnd
            {
                get
                {
                    return SystemColors.Control;
                }
            }

            /// <summary>
            /// Gets the tool strip gradient middle.
            /// </summary>
            public override Color ToolStripGradientMiddle
            {
                get
                {
                    return SystemColors.Control;
                }
            }

            /// <summary>
            /// ToolStripPanelのグラデーションの色を指定
            /// </summary>
            public override Color ToolStripPanelGradientBegin
            {
                get
                {
                    return SystemColors.Control;
                }
            }

            /// <summary>
            /// Gets the tool strip panel gradient end.
            /// </summary>
            public override Color ToolStripPanelGradientEnd
            {
                get
                {
                    return SystemColors.Control;
                }
            }

            #endregion
        }
    }
}
