﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.VisualStyles;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Specifics;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public class SearchCondition : ISettable, ICloneable
    {
        public SearchCondition()
        {
        }

        public SearchCondition(SearchCondition searchCondition) : this()
        {
            this.Set(searchCondition);
        }

        /// <summary>
        /// XPath を取得または設定します。
        /// （例）"EmitterBasicSettingData/EmitterBasicBasicData/ParticleFollowType"
        /// </summary>
        public string XPath { get; set; }

        /// <summary>
        /// ラベルを取得します。
        /// （例）"基本設定/基本設定/パーティクル追従タイプ"
        /// </summary>
        public string Label
        {
            get { return this.Category1 + "/" + Category2 + "/" + Category3; }

        }

        public string Category1 { get; set; }

        public string Category2 { get; set; }

        public string Category3 { get; set; }

        public Type Type { get; set; }

        public SearchValueProcessor Processor { get; set; }

        /// <summary>
        /// 特殊な検索を行うプラグインを取得または設定します。
        /// </summary>
        public SearchPlugin Plugin { get; set; }

        /// <summary>
        /// 条件値または置換値を取得または設定します。
        /// </summary>
        public object Value { get; set; }

        /// <summary>
        /// 比較方法または置換方法を取得または設定します。
        /// </summary>
        public int Operator { get; set; }

        public bool IsAttribute { get; set; } = false;

        public string Attribute { get; set; }

        public bool Set(object src)
        {
            var srcData = src as SearchCondition;
            if (srcData == null)
            {
                return false;
            }

            this.XPath = srcData.XPath;
            this.Category1 = srcData.Category1;
            this.Category2 = srcData.Category2;
            this.Category3 = srcData.Category3;
            this.Type = srcData.Type;
            this.Processor = (srcData.Processor != null ? (SearchValueProcessor)srcData.Processor.Clone() : null);
            this.Plugin = srcData.Plugin;
            this.Value = srcData.Value;
            this.Operator = srcData.Operator;
            this.IsAttribute = srcData.IsAttribute;
            this.Attribute = srcData.Attribute;

            return true;
        }

        public object Clone()
        {
            return new SearchCondition(this);
        }
    }
}
