﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EffectMaker.UIDialogs.MessageDialogs
{
    /// <summary>
    /// 不正描画パスの通知ダイログ.
    /// </summary>
    public partial class InvalidDrawPathDialog : Form
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        /// <param name="targetName">対象エミッタ名</param>
        /// <param name="showCancel">キャンセルボタンの表示On/Off</param>
        public InvalidDrawPathDialog(string targetName, bool showCancel)
        {
            this.InitializeComponent();

            this.Text = Properties.Resources.InvalidDrawPathDialogCaption;
            this.lblTarget.Text = targetName;
            this.picIcon.Image = SystemIcons.Question.ToBitmap();

            this.btnCancel.Visible = showCancel;
        }

        /// <summary>
        /// 「他の全ての項目に適用」チェックボックスのチェックOn/Offを取得します。
        /// </summary>
        public bool IsApplyToAll
        {
            get
            {
                return this.chkApplyToAll.Checked;
            }
        }
    }
}
