﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Layout;

namespace EffectMaker.UIDialogs.CurveEditorDialog
{
    /// <summary>
    /// コントロールのレイアウトと描画のブロッカーです。
    /// </summary>
    internal class ControlUpdateBlocker : IDisposable
    {
        /// <summary>
        /// ネストカウンタ
        /// </summary>
        private static int nestCount = 0;

        /// <summary>
        /// コントロール
        /// </summary>
        private static List<Control> controls = new List<Control>();

        /// <summary>
        /// 復帰時処理
        /// </summary>
        private Action action = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="control">対象コントロール</param>
        /// <param name="action">復帰時処理(省略可)</param>
        public ControlUpdateBlocker(Control control, Action action = null)
        {
            if (!controls.Contains(control))
            {
                control.SuspendDrawing();
                controls.Add(control);
            }

            this.action = action;

            ++nestCount;
            if (nestCount > 1)
            {
                return;
            }

            LayoutEngineBase.SuspendLayout();
        }

        /// <summary>
        /// ディスポーザー
        /// </summary>
        public void Dispose()
        {
            --nestCount;
            if (nestCount > 0)
            {
                return;
            }

            LayoutEngineBase.ResumeLayout();
            LayoutEngineBase.DelayLayout(0);
            foreach (var control in controls)
            {
                control.ResumeDrawing();
            }

            controls.Clear();

            if (this.action != null)
            {
                action();
            }
        }
    }
}
