﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reflection;
using System.Xaml.Schema;

namespace EffectMaker.UIControls.Xaml
{
    /// <summary>
    /// An extended XamlMemberInvoker class for regular properties.
    /// </summary>
    public class PropertyXamlMemberInvoker : XamlMemberInvoker
    {
        /// <summary>
        /// Stores the propertyInfo value received at the constructor.
        /// </summary>
        private PropertyInfo propertyInfo;

        /// <summary>
        /// Initializes the EffectMakerXamlMemberInvoker instance.
        /// </summary>
        /// <param name="propertyInfo">The property that represent this
        /// EffectMakerXamlMemberInvoker.</param>
        /// <param name="member">An instance of XamlMember class.</param>
        public PropertyXamlMemberInvoker(
            PropertyInfo propertyInfo,
            PropertyXamlMember member)
            : base(member)
        {
            this.propertyInfo = propertyInfo;
        }

        /// <summary>
        /// Sets the value of the property given at constructor, on the given instance.
        /// </summary>
        /// <param name="instance">Object that the property is to be set.</param>
        /// <param name="value">The value to set.</param>
        public override void SetValue(object instance, object value)
        {
            var control = instance as IBindable;

            if (control != null)
            {
                var binding = value as UIControls.DataBinding.Binding;

                if (binding != null)
                {
                    control.Bindings.Add(binding.CreateBinder(control, this.propertyInfo));

                    /*
                    //// When DataContext is set through binding,
                    //// the property MUST NOT be initialized to null.
                    //// Otherwise it result in being set with a null value instead of being unset.
                    if (this.propertyInfo.Name == "DataContext")
                    {
                        return;
                    }

                    if (UnderlyingGetter.ReturnType.IsValueType)
                    {
                        value = Activator.CreateInstance(UnderlyingGetter.ReturnType);
                    }
                    else
                    {
                        value = null;
                    }
                    */

                    return;
                }
            }

            base.SetValue(instance, value);
        }
    }
}
