﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xaml;
using System.Xaml.Schema;

namespace EffectMaker.UIControls.Xaml
{
    /// <summary>
    /// An extended XamlMember class that overrides the LookupInvoker
    /// method to provider a custom XamlMemberInvoker.
    /// </summary>
    public class AttachedPropertyXamlMember : XamlMember
    {
        /// <summary>
        /// Initializes the AttachedPropertyXamlMember instance.
        /// </summary>
        /// <param name="attachablePropertyName">The name of the attached property.</param>
        /// <param name="getter">The get method to retrieve value from attached target.</param>
        /// <param name="setter">The set method to set value to attached target.</param>
        /// <param name="schemaContext">The current schema context
        /// provided by the XAML engine.</param>
        public AttachedPropertyXamlMember(
            string attachablePropertyName,
            MethodInfo getter,
            MethodInfo setter,
            XamlSchemaContext schemaContext)
            : base(attachablePropertyName, getter, setter, schemaContext)
        {
        }

        /// <summary>
        /// Provides a AttachedPropertyXamlMemberInvoker.
        /// </summary>
        /// <returns>Returns an instance of AttachedPropertyXamlMemberInvoker class.</returns>
        protected override XamlMemberInvoker LookupInvoker()
        {
            var getter = this.LookupUnderlyingGetter();
            var setter = this.LookupUnderlyingSetter();

            return new AttachedPropertyXamlMemberInvoker(getter, setter);
        }

        /// <summary>
        /// Tells whether the lookup is unknwon or not.
        /// </summary>
        /// <returns>Always return false, as the lookup is known.</returns>
        protected override bool LookupIsUnknown()
        {
            return false;
        }
    }
}
