﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Windows.Forms.Layout;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extenders;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Layout;

namespace EffectMaker.UIControls.SpecificControls
{
    /// <summary>
    /// An extended UIPanel supporting IItemsControl interface.
    /// </summary>
    public class UIItemsControl : UIPanel, IItemsControl
    {
        /// <summary>
        /// Backing field for LayoutEngine.
        /// </summary>
        private LayoutEngine layoutEngine = new StackLayoutEngine();

        /// <summary>
        /// Stores the ItemsControlExtender instance.
        /// </summary>
        private ItemsControlExtender itemsControlExtender;

        /// <summary>
        /// Initializes an UIItemsControl instance.
        /// </summary>
        public UIItemsControl()
        {
            this.itemsControlExtender = new ItemsControlExtender(this);
        }

        /// <summary>
        /// Gets the layout engine.
        /// </summary>
        public override LayoutEngine LayoutEngine
        {
            get
            {
                return this.layoutEngine;
            }
        }

        /// <summary>
        /// Gets or sets the layout engine.
        /// </summary>
        public LayoutEngine OverrideLayoutEngine
        {
            get
            {
                return this.layoutEngine;
            }

            set
            {
                this.layoutEngine = value;
                this.PerformLayout();
            }
        }

        /// <summary>
        /// Gets or sets the child items.
        /// </summary>
        public IEnumerable ItemsSource
        {
            get { return this.itemsControlExtender.ItemsSource; }
            set { this.itemsControlExtender.ItemsSource = value; }
        }

        /// <summary>
        /// Gets or sets the type of item container to construct.
        /// If this is null, the ItemContainerSelector is used.
        /// </summary>
        public Type ItemContainerType
        {
            get { return this.itemsControlExtender.ItemContainerType; }
            set { this.itemsControlExtender.ItemContainerType = value; }
        }

        /// <summary>
        /// Gets or sets the item container selector.
        /// If this is null, no item container is instanced.
        /// </summary>
        public IItemContainerSelector ItemContainerSelector
        {
            get { return this.itemsControlExtender.ItemContainerSelector; }
            set { this.itemsControlExtender.ItemContainerSelector = value; }
        }

        /// <summary>
        /// Compares two child controls for sorting.
        /// </summary>
        /// <param name="a">First control.</param>
        /// <param name="b">Second control.</param>
        /// <returns>Returns 0 if equal, 1 or -1 if different depending on order.</returns>
        public virtual int CompareControls(IControl a, IControl b)
        {
            return 0;
        }

        /// <summary>
        /// Retrieve the data item corresponding to the container.
        /// </summary>
        /// <param name="container">The container to look for its data item.</param>
        /// <returns>Returns the data item, or null if not found.</returns>
        public object GetDataItemFromContainer(IControl container)
        {
            return this.itemsControlExtender.GetDataItemFromContainer(container);
        }

        /// <summary>
        /// Retrieve the container corresponding to the data item.
        /// </summary>
        /// <param name="dataItem">The data item to look for its data.</param>
        /// <returns>Returns the container, or null if not found.</returns>
        public IControl GetContainerFromDataItem(object dataItem)
        {
            return this.itemsControlExtender.GetContainerFromDataItem(dataItem);
        }

        /// <summary>
        /// Called when a child control is added.
        /// </summary>
        /// <param name="e">Event argument.</param>
        protected override void OnControlAdded(ControlEventArgs e)
        {
            base.OnControlAdded(e);

            this.itemsControlExtender.ThrowIfIllegalAdd();
        }
    }
}
