﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms.Layout;
using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIControls.Layout
{
    /// <summary>
    /// An extended UIPanel class that support base layout capabilities.
    /// </summary>
    /// <typeparam name="TLayoutEngine">The type of underlying LayoutEngine instance.</typeparam>
    public abstract class UILayoutPanel<TLayoutEngine> : UIPanel
        where TLayoutEngine : LayoutEngineBase
    {
        /// <summary>
        /// Initializes the panel instance.
        /// It call ProduceLayoutEngine method, then OnInitialized one.
        /// </summary>
        public UILayoutPanel()
        {
            this.InternalLayoutEngine = this.ProduceLayoutEngine();

            if (this.InternalLayoutEngine == null)
            {
                // TODO: Make it localizable.
                throw new InvalidOperationException("A LayoutEngine must be produced.");
            }

            this.InternalLayoutEngine.RequestLayout += this.OnInternalLayoutEngineRequestLayout;
            this.OnInitialized();
        }

        /// <summary>
        /// Gets a GridLayoutEngine instance.
        /// </summary>
        public override LayoutEngine LayoutEngine
        {
            get
            {
                return this.InternalLayoutEngine;
            }
        }

        /// <summary>
        /// Gets the typed layout engine instance.
        /// </summary>
        protected TLayoutEngine InternalLayoutEngine { get; private set; }

        /// <summary>
        /// When overridden, produces a specific layout engine instance.
        /// </summary>
        /// <returns>Returns a layout engine instance.</returns>
        protected abstract TLayoutEngine ProduceLayoutEngine();

        /// <summary>
        /// When overridden, used to initialize the panel if needed.
        /// </summary>
        protected virtual void OnInitialized()
        {
        }

        /// <summary>
        /// Called when the control is being disposed.
        /// </summary>
        /// <param name="disposing">Tells whether the control is disposing or finalizing.</param>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
            this.InternalLayoutEngine.RequestLayout -= this.OnInternalLayoutEngineRequestLayout;
        }

        /// <summary>
        /// Called when the layout phase must be performed once again.
        /// </summary>
        /// <param name="sender">Caller of the event.</param>
        /// <param name="e">Event argument.</param>
        private void OnInternalLayoutEngineRequestLayout(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                this.PerformLayout();
            }
        }
    }
}
