﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Extenders;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// ツリー構造 (LogicalTree) の要素となりうるクラスのインターフェースです。
    /// </summary>
    public interface ILogicalTreeElement : INotifyPropertyChanged
    {
        /// <summary>
        /// LogicalTreeElementExtender を取得します。
        /// </summary>
        LogicalTreeElementExtender LogicalTreeElementExtender { get; }

        /// <summary>
        /// データコンテキストを取得または設定します。
        /// 詳細については ControlExtender を参照してください。
        /// <see cref="ControlExtender"/>
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        object DataContext { get; set; }

        /// <summary>
        /// 親コントロールを取得します。
        /// </summary>
        ILogicalTreeElement Parent { get; }

        /// <summary>
        /// チャイルドコントロールのコレクションを取得します。
        /// </summary>
        IIndexableCollection<ILogicalTreeElement> Children { get; }

        /// <summary>
        /// データコンテキストをクリアします。
        /// 詳細については ControlExtender を参照してください。
        /// <see cref="ControlExtender"/>
        /// </summary>
        void ClearDataContext();
    }
}
