﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// Interface for controls that the tab focus of it's children can be controlled.
    /// </summary>
    public interface IChildrenFocusable
    {
        /// <summary>
        /// Select (focus on) the first child control in the property page.
        /// </summary>
        /// <param name="forward">False to select the last child control.</param>
        void SelectFirstChildControl(bool forward);
    }
}
