﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.UIControls.EventArguments
{
    /// <summary>
    /// Event argument class for the pre-filter key events.
    /// </summary>
    public class PreFilterKeyEventArgs : EventArgs
    {
        /// <summary>
        /// Contructor.
        /// </summary>
        /// <param name="keyCode">The key code.</param>
        public PreFilterKeyEventArgs(Keys keyCode) :
            base()
        {
            this.KeyCode = keyCode;
            this.Filter = false;
        }

        /// <summary>
        /// Get or set the flag indicating whether to filter the event and stop it
        /// from being dispatched.
        /// </summary>
        public bool Filter { get; set; }

        /// <summary>
        /// Get the key code related to the key event.
        /// </summary>
        public Keys KeyCode { get; private set; }
    }
}
