﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Debug
{
    /// <summary>
    /// An extended PabPage to store control information.
    /// </summary>
    public class ControlTreeTabPage : TabPage
    {
        /// <summary>
        /// Initializes the ControlTreeTabPage instance.
        /// </summary>
        /// <param name="rootForm">The root from represented by this tab page.</param>
        public ControlTreeTabPage(Form rootForm)
        {
            if (rootForm == null)
            {
                throw new ArgumentNullException("rootForm");
            }

            this.RootForm = rootForm;

            var controlTreeViewerControl = new ControlTreeViewerControl(rootForm);
            controlTreeViewerControl.Dock = DockStyle.Fill;
            controlTreeViewerControl.TitleChanged +=
                (ss, ee) => this.Text = controlTreeViewerControl.Title;

            this.Text = controlTreeViewerControl.Title;

            rootForm.FormClosed += this.OnRootFormClosed;

            this.Controls.Add(controlTreeViewerControl);
        }

        /// <summary>
        /// Gets the roor form.
        /// </summary>
        public Form RootForm { get; private set; }

        /// <summary>
        /// Called when this tab page is disposed.
        /// </summary>
        /// <param name="disposing">Tells wether it is disposing or finalizing.</param>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);

            this.RootForm.FormClosed -= this.OnRootFormClosed;
        }

        /// <summary>
        /// Called when the main form is closed.
        /// </summary>
        /// <param name="sender">Event caller.</param>
        /// <param name="e">Event argument.</param>
        private void OnRootFormClosed(object sender, FormClosedEventArgs e)
        {
            var tabControl = this.Parent as TabControl;

            if (tabControl != null)
            {
                tabControl.TabPages.Remove(this);
            }
        }
    }
}
