﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// 文字列が有効かどうか
    /// </summary>
    public class AlphaToRgbaColorValueConverter : IValueConverter
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public AlphaToRgbaColorValueConverter()
        {
        }

        /// <summary>
        /// Convert a value from a type to another.
        /// </summary>
        /// <param name="value">The value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns the converted value.</returns>
        public object Convert(
            object value,
            Type targetType,
            object parameter)
        {
            if ((value is float) == false)
            {
                return null;
            }

            return new ColorRgba(1.0f, 1.0f, 1.0f, (float)value);
        }

        /// <summary>
        /// Convert a value from a type to another.
        /// </summary>
        /// <param name="value">The value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns the converted value.</returns>
        public object ConvertBack(
            object value,
            Type targetType,
            object parameter)
        {
            if ((value is ColorRgba) == false)
            {
                return 1.0f;
            }

            return (value as ColorRgba).A;
        }
    }
}
