﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UIControls.Specifics.ColorPicker
{
    /// <summary>
    /// Interface for color key frame editors.
    /// </summary>
    public interface IColorKeyEditor
    {
        /// <summary>
        /// Event being triggered when the active (editing) target is changed.
        /// </summary>
        event EventHandler ActiveTargetChanged;

        /// <summary>
        /// Get or set the editing key value.
        /// </summary>
        ColorRgba KeyValue { get; set; }

        /// <summary>
        /// Get or set the editing key time.
        /// </summary>
        int KeyTime { get; set; }

        /// <summary>
        /// Set the connected target to edit the color with.
        /// </summary>
        /// <param name="editor">The target.</param>
        void SetConnectedTarget(IColorPickerConnectable editor);

        /// <summary>
        /// Unset the connected target to edit the color with.
        /// </summary>
        /// <param name="editor">The target.</param>
        void UnsetConnectedTarget(IColorPickerConnectable editor);

        /// <summary>
        /// Get the connect target to edit the color with.
        /// </summary>
        /// <returns>The connected target.</returns>
        IColorPickerConnectable GetConnectedTarget();
    }
}
