﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.UIControls.Specifics.ClipboardDataTypes
{
    /// <summary>
    /// 色クリップボードデータ
    /// </summary>
    [Serializable]
    public class ColorClipboardData
    {
        /// <summary>
        /// クリップボードフォーマット
        /// </summary>
        public static readonly string ClipboardFormat = typeof(ColorClipboardData).ToString();

        /// <summary>
        /// 赤
        /// </summary>
        public float R { get; set; }

        /// <summary>
        /// 緑
        /// </summary>
        public float G { get; set; }

        /// <summary>
        /// 青
        /// </summary>
        public float B { get; set; }

        /// <summary>
        /// アルファ
        /// </summary>
        public float A { get; set; }

        /// <summary>
        /// RGB情報は有効か
        /// </summary>
        public bool EnabledRgb { get; set; }

        /// <summary>
        /// Alpha情報は有効か
        /// </summary>
        public bool EnabledAlpha { get; set; }
    }
}
