﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// ベクトルのインターフェースです。
    /// </summary>
    public interface IVector
    {
        /// <summary>
        /// 次元数を取得します。
        /// </summary>
        int Dimension { get; }

        /// <summary>
        /// 指定したインデックス位置の成分を取得します。
        /// </summary>
        /// <param name="i">インデックスです。</param>
        /// <returns>成分です。</returns>
        float this[int i] { get; set; }

        /// <summary>
        /// 座標を格納した配列を返します。
        /// </summary>
        /// <returns>座標の配列です。</returns>
        float[] ToArray();

        /// <summary>
        /// 成分を 0 に設定します。
        /// </summary>
        void SetZero();

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        void Set(object source);

        /// <summary>
        /// 成分を指定の値に設定します。
        /// </summary>
        /// <param name="source">成分の配列です。</param>
        void Set(float[] source);
    }
}
