﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    using System;

    /// <summary>
    /// XML コンテンツのリゾルバです。
    /// </summary>
    public interface IXmlContentResolver
    {
        /// <summary>
        /// 有効なバージョン条件を取得または設定します。
        /// </summary>
        Predicate<string> ValidVersionCheckHandler { get; set; }

        /// <summary>
        /// 対象とするコンテンツの名前を取得または設定します。
        /// </summary>
        string TargetContentName { get; set; }

        /// <summary>
        /// Updaterを登録します。一度だけ呼びだします。
        /// </summary>
        /// <param name="contentUpdaterSet">Updaterのセットです。</param>
        void InitializeUpdaters(IXmlContentUpdater[] contentUpdaterSet);

        /// <summary>
        /// コンテンツの名前からコンテンツを解決します。
        /// <para>
        /// validVersionが満たされない場合には、BadArgumentExveptionを送出します。
        /// </para>
        /// </summary>
        /// <param name="name">コンテンツの名前です。</param>
        /// <param name="xmlSubDocument">コンテンツです。</param>
        /// <returns>解決したコンテンツです。</returns>
        IXmlContent Resolve(string name, string xmlSubDocument);
    }
}
