﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using EffectMaker.DataModel.DataModels;
using EffectMaker.Foundation.Serialization;
using Microsoft.CSharp;

namespace EffectMaker.DataModel.Manager
{
    /// <summary>
    /// データモデルシリアライザのエクストラデータ管理.
    /// </summary>
    public class DataModelSerializerExtraDataManager
    {
        /// <summary>
        /// XMLシリアライザを作成。
        /// </summary>
        private static readonly Type[] ExtraTypes = new Type[]
        {
            typeof(RandomData),
            typeof(MagnetData),
            typeof(SpinData),
            typeof(ConvergeData),
            typeof(AddLocationData),
            typeof(CollisionData),
            typeof(CurlNoiseData),
            typeof(StripeSuperData),
            typeof(StripeHistoryData),
        };

        /// <summary>
        /// ユーザー定義クラスのタイプ.
        /// </summary>
        private static readonly List<Type> UserDataExtraTypes = new List<Type>();

        /// <summary>
        /// Initialize.
        /// </summary>
        /// <returns>True on success.</returns>
        public static bool Initialize()
        {
            SerializationHelper.RequestExtraTypes += (s, e) => e.AddExtraTypes(DataModelSerializerExtraDataManager.GetExtraTypes());
            SerializationHelper.RequestExtraTypes += (s, e) => e.AddExtraTypes(EmitterCustomShaderSettingManager.Instance.GetExtraTypes());
            SerializationHelper.RequestExtraTypes += (s, e) => e.AddExtraTypes(CustomActionSettingManager.Instance.GetExtraTypes());
            return true;
        }

        /// <summary>
        /// ユーザー定義クラスタイプを追加する.
        /// </summary>
        /// <param name="type">追加するタイプ情報.</param>
        public static void AddUserDataType(Type type)
        {
            System.Diagnostics.Debug.Assert(type != null, "typeがnullです。");

            UserDataExtraTypes.Add(type);
        }

        /// <summary>
        /// ユーザー定義クラスタイプをクリアする.
        /// </summary>
        public static void ClearUserDataType()
        {
            UserDataExtraTypes.Clear();
        }

        /// <summary>
        /// エクストラデータを取得する.
        /// </summary>
        /// <returns>エクストラデータの配列.</returns>
        public static IEnumerable<Type> GetExtraTypes()
        {
            return ExtraTypes.Concat(UserDataExtraTypes);
        }
    }
}
