﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/カメラタブ/射影グループです。
    /// </summary>
    [Serializable]
    public class ViewerProjectionData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerProjectionData() :
            base()
        {
            this.ProjectionType = 0;
            this.AspectRatio = 1.66f;
            this.ImageSize = 72.0f;
            this.FieldOfView = 50.0f;
            this.NearClip = 0.01f;
            this.FarClip = 1000.0f;
        }

        /// <summary>
        /// 射影タイプです.
        /// </summary>
        [DataModelPropertyGuid("bddc93c4-cb27-4a11-a576-df6f59713c13")]
        public int ProjectionType { get; set; }

        /// <summary>
        /// アスペクト比です.
        /// </summary>
        [DataModelPropertyGuid("a637cab0-6233-49ae-83f7-7454e9d4bf18")]
        public float AspectRatio { get; set; }

        /// <summary>
        /// イメージサイズです.
        /// </summary>
        [DataModelPropertyGuid("15069c87-9464-44d8-9d3b-4a399c4c4aa9")]
        public float ImageSize { get; set; }

        /// <summary>
        /// 垂直画角です.
        /// </summary>
        [DataModelPropertyGuid("13c52615-7e01-4a80-9484-8677e00a05e8")]
        public float FieldOfView { get; set; }

        /// <summary>
        /// 近クリップ平面への距離です.
        /// </summary>
        [DataModelPropertyGuid("f92ee87f-2ab3-4f18-a694-223006b77918")]
        public float NearClip { get; set; }

        /// <summary>
        /// 遠クリップ平面への距離です.
        /// </summary>
        [DataModelPropertyGuid("324787a5-32aa-4f7e-a769-54dda969000e")]
        public float FarClip { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerProjectionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ProjectionType = srcDataModel.ProjectionType;
            this.AspectRatio = srcDataModel.AspectRatio;
            this.ImageSize = srcDataModel.ImageSize;
            this.FieldOfView = srcDataModel.FieldOfView;
            this.NearClip = srcDataModel.NearClip;
            this.FarClip = srcDataModel.FarClip;

            return true;
        }
    }
}
