﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/背景画像タブ/背景カラーグループです。
    /// </summary>
    [Serializable]
    public class ViewerBackgroundColorData : DataModelBase
    {
        /// <summary>
        /// クリアカラーです。
        /// </summary>
        private ColorRgba clearColor = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBackgroundColorData() :
            base()
        {
            this.ClearColor = new ColorRgba(0.03f, 0.03f, 0.03f, 1.0f);
        }

        /// <summary>
        /// クリアカラーです。
        /// </summary>
        [DataModelPropertyGuid("5804faf6-ecc6-489c-abed-dec3ee3c6897")]
        public ColorRgba ClearColor
        {
            get { return this.GetObjectFromField(ref this.clearColor, false); }
            set { this.SetISettableToField(ref this.clearColor, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerBackgroundColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ClearColor = srcDataModel.ClearColor;

            return true;
        }
    }
}
