﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Reflection;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カラー.
    /// </summary>
    [Serializable]
    public class PreviewColorData : DataModelBase
    {
        /// <summary>
        /// カラー(EmitterSet::SetAlpha/SetColor).
        /// </summary>
        private Vector4f color = null;

        /// <summary>
        /// エミッタカラー0
        /// </summary>
        private Vector3f emitterColor0 = null;

        /// <summary>
        /// エミッタカラー1
        /// </summary>
        private Vector3f emitterColor1 = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewColorData() :
            base()
        {
            this.Color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.EnableEmitterColor = false;
            this.EmitterColor0 = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterColor1 = new Vector3f(1.0f, 1.0f, 1.0f);
        }

        /// <summary>
        /// カラー(EmitterSet::SetAlpha/SetColor).
        /// </summary>
        [DataModelPropertyGuid("21a63b0f-9d62-4e47-9181-103e2444ddc7")]
        public Vector4f Color
        {
            get { return this.GetObjectFromField(ref this.color, false); }
            set { this.SetISettableToField(ref this.color, value); }
        }

        /// <summary>
        /// エミッタカラーに対する乗算
        /// </summary>
        [DataModelPropertyGuid("74d5eed4-9520-4152-8fac-2741a603dfe6")]
        public bool EnableEmitterColor { get; set; }

        /// <summary>
        /// エミッタカラー0
        /// </summary>
        [DataModelPropertyGuid("1ba8dfab-665c-4a91-9a9e-687fa8403db5")]
        public Vector3f EmitterColor0
        {
            get { return this.GetObjectFromField(ref this.emitterColor0, false); }
            set { this.SetISettableToField(ref this.emitterColor0, value); }
        }

        /// <summary>
        /// エミッタカラー1
        /// </summary>
        [DataModelPropertyGuid("23afecf9-373a-4d20-b47b-a815d52714ce")]
        public Vector3f EmitterColor1
        {
            get { return this.GetObjectFromField(ref this.emitterColor1, false); }
            set { this.SetISettableToField(ref this.emitterColor1, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PreviewColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Color = srcDataModel.Color;
            this.EnableEmitterColor = srcDataModel.EnableEmitterColor;
            this.EmitterColor0 = srcDataModel.EmitterColor0;
            this.EmitterColor1 = srcDataModel.EmitterColor1;

            return true;
        }
    }
}
