﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterRotationBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationBasicData() :
            base()
        {
            this.RotationType = 4;
            this.RotationAttenuation = 1.0f;
            this.EnableRotationAxisX = false;
            this.EnableRotationAxisY = false;
            this.EnableRotationAxisZ = false;
        }

        /// <summary>
        /// 回転タイプです.
        /// </summary>
        [DataModelPropertyGuid("a88ffd8a-1b31-4911-855b-5df33c50093d")]
        public int RotationType { get; set; }

        /// <summary>
        /// 減衰率です.
        /// </summary>
        [DataModelPropertyGuid("687a7828-de71-4ef5-9b32-411c99068d24")]
        public float RotationAttenuation { get; set; }

        /// <summary>
        /// 回転軸Xが有効かどうか.
        /// </summary>
        [DataModelPropertyGuid("c071fc6c-5537-4a58-a948-97a63c88ec70")]
        public bool EnableRotationAxisX { get; set; }

        /// <summary>
        /// 回転軸Yが有効かどうか.
        /// </summary>
        [DataModelPropertyGuid("b3ff1b03-9219-4276-8953-4fb986cdac70")]
        public bool EnableRotationAxisY { get; set; }

        /// <summary>
        /// 回転軸Zが有効かどうか.
        /// </summary>
        [DataModelPropertyGuid("9f044a34-4d60-49f7-a4e4-dedc024c09dd")]
        public bool EnableRotationAxisZ { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterRotationBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RotationType = srcDataModel.RotationType;
            this.RotationAttenuation = srcDataModel.RotationAttenuation;
            this.EnableRotationAxisX = srcDataModel.EnableRotationAxisX;
            this.EnableRotationAxisY = srcDataModel.EnableRotationAxisY;
            this.EnableRotationAxisZ = srcDataModel.EnableRotationAxisZ;

            return true;
        }
    }
}
