﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/パーティクルタブ/パーティクル寿命グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterParticleLifeData : DataModelBase
    {
        /// <summary>
        /// 寿命のアニメーションデータセットです。
        /// </summary>
        private EmitterAnimationCommonData lifeAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleLifeData() :
            base()
        {
            this.EnableInfinityLife = false;
            this.Life = 100;
            this.LifeRandom = 0.0f;
        }

        /// <summary>
        /// 寿命無限を有効にするかどうかのフラグです.
        /// </summary>
        [DataModelPropertyGuid("e075d30a-d94b-455f-a196-7e3632114da4")]
        public bool EnableInfinityLife { get; set; }

        /// <summary>
        /// 寿命です.
        /// </summary>
        [DataModelPropertyGuid("0f365860-f691-427d-84c0-0e5166edf3ba")]
        public int Life { get; set; }

        /// <summary>
        /// 寿命のアニメーションデータセットです。
        /// </summary>
        [DataModelPropertyGuid("0ee5daac-ba01-4afb-a1e7-22942837a3d0")]
        public EmitterAnimationCommonData LifeAnimation
        {
            get { return this.GetDataModelFromField(ref this.lifeAnimation, false); }
            set { this.SetDataModelToField(ref this.lifeAnimation, value); }
        }

        /// <summary>
        /// 寿命ランダムです.
        /// </summary>
        [DataModelPropertyGuid("fcd8e736-c19a-4810-89ad-fdd32559e49b")]
        public float LifeRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterParticleLifeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableInfinityLife = srcDataModel.EnableInfinityLife;
            this.Life = srcDataModel.Life;
            this.LifeAnimation = srcDataModel.LifeAnimation;
            this.LifeRandom = srcDataModel.LifeRandom;

            return true;
        }
    }
}
