﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 揺らぎ設定グループのサブグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterParticleFluctionSettingData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleFluctionSettingData() :
            base()
        {
            this.Amplitude = 1.0f;
            this.Frequency = 20;
            this.InitPhase = 1.0f;
            this.PhaseRandom = false;
        }

        /// <summary>
        /// 振幅です.
        /// </summary>
        [DataModelPropertyGuid("15c34abb-9cfc-4892-885a-d30f4eb6877b")]
        public float Amplitude { get; set; }

        /// <summary>
        /// 周期です.
        /// </summary>
        [DataModelPropertyGuid("dab34770-0929-4225-96dd-1380ed869774")]
        public int Frequency { get; set; }

        /// <summary>
        /// 初期位相です.
        /// </summary>
        [DataModelPropertyGuid("76ba4eae-98a5-4e08-bd5f-d549c4786f0a")]
        public float InitPhase { get; set; }

        /// <summary>
        /// 位相ランダムです.
        /// </summary>
        [DataModelPropertyGuid("ac9f7aa0-bab8-46ab-8835-e5b6f15c93b9")]
        public bool PhaseRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterParticleFluctionSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Amplitude = srcDataModel.Amplitude;
            this.Frequency = srcDataModel.Frequency;
            this.InitPhase = srcDataModel.InitPhase;
            this.PhaseRandom = srcDataModel.PhaseRandom;

            return true;
        }
    }
}
