﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタタブデータです.
    /// </summary>
    [Serializable]
    public class EmitterEmitterData : DataModelBase
    {
        /// <summary>
        /// エミッタ形状グループです.
        /// </summary>
        private EmitterEmitterShapeData emitterEmitterShapeData = null;

        /// <summary>
        /// エミッタトランスフォームグループです.
        /// </summary>
        private EmitterEmitterTransformData emitterEmitterTransformData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterData() :
            base()
        {
        }

        /// <summary>
        /// エミッタ形状グループです.
        /// </summary>
        [DataModelPropertyGuid("80f2a4e9-274b-4097-8fdc-8b7307376b25")]
        public EmitterEmitterShapeData EmitterEmitterShapeData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterShapeData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterShapeData, value); }
        }

        /// <summary>
        /// エミッタトランスフォームグループです.
        /// </summary>
        [DataModelPropertyGuid("25d6d6b5-0524-4a1b-9875-80822ab1badc")]
        public EmitterEmitterTransformData EmitterEmitterTransformData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterTransformData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterTransformData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterEmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterEmitterShapeData = srcDataModel.EmitterEmitterShapeData;
            this.EmitterEmitterTransformData = srcDataModel.EmitterEmitterTransformData;

            return true;
        }
    }
}
