﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Data model for emitter node / combiner page / combiner editor group.
    /// </summary>
    [Serializable]
    public class EmitterCombinerEditorData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerEditorData() :
            base()
        {
            this.CombinerEditorProjectPath = string.Empty;
        }

        /// <summary>
        /// Get or set the file path of the effect combiner editor project.
        /// </summary>
        [DataModelPropertyGuid("c07be36b-2ce7-4ab5-b66d-bbfb169e6b45")]
        public string CombinerEditorProjectPath { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterCombinerEditorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CombinerEditorProjectPath = srcDataModel.CombinerEditorProjectPath;

            return true;
        }
    }
}
