﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カラータブデータです.
    /// </summary>
    [Serializable]
    public class EmitterColorData : DataModelBase
    {
        /// <summary>
        /// カラー計算グループです.
        /// </summary>
        private EmitterColorCalculationData emitterColorCalculationData = null;

        /// <summary>
        /// カラー・アルファ設定グループです.
        /// </summary>
        private EmitterColorSettingsData emitterColorSettingsData = null;

        /// <summary>
        /// アルファ処理グループです.
        /// </summary>
        private EmitterColorAlphaProcessingData emitterColorAlphaProcessData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorData() :
            base()
        {
        }

        /// <summary>
        /// カラー計算グループです.
        /// </summary>
        [DataModelPropertyGuid("47777185-8186-43e6-87f7-0d5fd2745b47")]
        public EmitterColorCalculationData EmitterColorCalculationData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorCalculationData, false); }
            set { this.SetDataModelToField(ref this.emitterColorCalculationData, value); }
        }

        /// <summary>
        /// カラー・アルファ設定グループです.
        /// </summary>
        [DataModelPropertyGuid("111ccdd5-c0fa-49bb-918e-2754ef632820")]
        public EmitterColorSettingsData EmitterColorSettingsData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorSettingsData, false); }
            set { this.SetDataModelToField(ref this.emitterColorSettingsData, value); }
        }

        /// <summary>
        /// アルファ処理グループです.
        /// </summary>
        [DataModelPropertyGuid("2c1dda04-fb77-4c6a-949f-77476e6a537d")]
        public EmitterColorAlphaProcessingData EmitterColorAlphaProcessData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorAlphaProcessData, false); }
            set { this.SetDataModelToField(ref this.emitterColorAlphaProcessData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterColorCalculationData = srcDataModel.EmitterColorCalculationData;
            this.EmitterColorSettingsData = srcDataModel.EmitterColorSettingsData;
            this.EmitterColorAlphaProcessData = srcDataModel.EmitterColorAlphaProcessData;

            return true;
        }
    }
}
