﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブ/描画設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicRenderData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicRenderData() :
            base()
        {
            this.EnableDispParticle = true;
            this.DrawPath = 0;
            this.ParticleSortOrder = 0;
            this.DisplaySurface = 0;
            this.BlendType = 0;
            this.ZbufferAlphaTestType = 0;
        }

        /// <summary>
        /// パーティクル描画フラグです
        /// </summary>
        [DataModelPropertyGuid("cc192167-b4d7-4ad6-9f58-49dc8b62b28a")]
        public bool EnableDispParticle { get; set; }

        /// <summary>
        /// 描画パスです
        /// </summary>
        [DataModelPropertyGuid("0899dfa3-117d-40b1-abc2-36ecf4f0ebc7")]
        public int DrawPath { get; set; }

        /// <summary>
        /// 描画パス名です
        /// </summary>
        public string DrawPathName { get; set; }

        /// <summary>
        /// パーティクルソートです。
        /// </summary>
        [DataModelPropertyGuid("5f1daae5-157c-4931-a0f4-403dc805a19b")]
        public int ParticleSortOrder { get; set; }

        /// <summary>
        /// 表示面です。
        /// </summary>
        [DataModelPropertyGuid("0ab41910-8daa-4a2e-8cf4-b687ae4ace31")]
        public int DisplaySurface { get; set; }

        /// <summary>
        /// ブレンドタイプです。
        /// </summary>
        [DataModelPropertyGuid("54a85cdf-eb38-4a82-a483-a5c6579cdcb6")]
        public int BlendType { get; set; }

        /// <summary>
        /// Zバッファ・αテストです。
        /// </summary>
        [DataModelPropertyGuid("3475cacc-0a92-4386-8c37-7d6c7756153c")]
        public int ZbufferAlphaTestType { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterBasicRenderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableDispParticle = srcDataModel.EnableDispParticle;
            this.DrawPath = srcDataModel.DrawPath;
            this.ParticleSortOrder = srcDataModel.ParticleSortOrder;
            this.DisplaySurface = srcDataModel.DisplaySurface;
            this.BlendType = srcDataModel.BlendType;
            this.ZbufferAlphaTestType = srcDataModel.ZbufferAlphaTestType;

            return true;
        }
    }
}
