﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Windows.Forms;

namespace NWCore.DebugConsole
{
    /// <summary>
    /// Debug オーナー用のインターフェイスです。
    /// </summary>
    public interface IDebugConsoleOwner
    {
        /// <summary>
        /// コマンドキー処理
        /// </summary>
        /// <param name="msg">Messageです</param>
        /// <param name="keyData">キー情報です</param>
        /// <returns>キーストロークがコントロールによって処理および使用された場合は true。
        /// キーストロークをさらに処理できるようにする場合は false。</returns>
        bool ProcessCommandKey(ref Message msg, Keys keyData);
    }
}
